/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.helper;

import com.mojang.brigadier.StringReader;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import tschipp.carryon.common.helper.InvalidConfigException;

public class StringParser {
    @Nullable
    public static Block getBlock(String string) {
        BlockState state = StringParser.getBlockState(string);
        if (state != null) {
            return state.m_60734_();
        }
        return null;
    }

    @Nullable
    public static BlockState getBlockState(String string) {
        if (string == null) {
            return null;
        }
        BlockStateParser parser = new BlockStateParser(new StringReader(string), false);
        try {
            parser.m_116806_(false);
            return parser.m_116808_();
        }
        catch (Exception e) {
            new InvalidConfigException("Blockstate parsing Exception at: " + string + " : " + e.getMessage()).printException();
            return null;
        }
    }

    @Nullable
    public static Item getItem(String string) {
        if (string == null) {
            return null;
        }
        ItemParser parser = new ItemParser(new StringReader(string), false);
        try {
            parser.m_121032_();
            return parser.m_121014_();
        }
        catch (Exception e) {
            new InvalidConfigException("Item parsing Exception at: " + string + " : " + e.getMessage()).printException();
            return null;
        }
    }

    public static ItemStack getItemStack(String string) {
        if (string == null) {
            return null;
        }
        ItemParser parser = new ItemParser(new StringReader(string), false);
        try {
            parser.m_121032_();
            Item item = parser.m_121014_();
            CompoundTag nbt = parser.m_121018_();
            ItemStack stack = new ItemStack((ItemLike)item, 1);
            if (nbt != null) {
                stack.m_41751_(nbt);
            }
            return stack;
        }
        catch (Exception e) {
            new InvalidConfigException("Item parsing Exception at: " + string + " : " + e.getMessage()).printException();
            return ItemStack.f_41583_;
        }
    }

    @Nullable
    public static CompoundTag getTagCompound(String string) {
        CompoundTag tag = null;
        if (string == null) {
            return null;
        }
        if (string.contains("{")) {
            if (!string.contains("}")) {
                new InvalidConfigException("Missing } at  : " + string).printException();
            }
            String nbt = string.substring(string.indexOf("{"));
            string = string.replace(nbt, "");
            try {
                tag = TagParser.m_129359_((String)nbt);
            }
            catch (Exception e) {
                new InvalidConfigException("Error while parsing NBT: " + e.getMessage()).printException();
                return null;
            }
        } else if (string.contains("}")) {
            new InvalidConfigException("Missing { at  : " + string).printException();
        }
        return tag;
    }
}

