/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.network.server;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;

public class SyncKeybindPacket {
    public boolean pressed;

    public SyncKeybindPacket(ByteBuf buf) {
        this.pressed = buf.readBoolean();
    }

    public SyncKeybindPacket(boolean pressed) {
        this.pressed = pressed;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.pressed);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isServer()) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                CarryOnKeybinds.setKeyPressed((Player)player, this.pressed);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }
}

