/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import tschipp.carryon.client.helper.CarryRenderHelper;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemCarryonEntity;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;

public class RenderEntityEvents {
    public static final Map<String, Entity> nbtEntityMap = new HashMap<String, Entity>();

    public static Entity getEntity(ItemStack carried, Level level) {
        String nbt = ItemCarryonEntity.getPersistentData(carried).toString();
        if (nbtEntityMap.containsKey(nbt)) {
            return nbtEntityMap.get(nbt);
        }
        Entity entity = ItemCarryonEntity.getEntity(carried, level);
        nbtEntityMap.put(nbt, entity);
        return entity;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onLevelUnload(WorldEvent.Unload event) {
        nbtEntityMap.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack stack = player.m_21205_();
        int perspective = CarryRenderHelper.getPerspective();
        float partialticks = event.getPartialTicks();
        PoseStack matrix = event.getPoseStack();
        int light = event.getPackedLight();
        MultiBufferSource buffer = event.getMultiBufferSource();
        EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
        if (!stack.m_41619_() && stack.m_41720_() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack)) {
            if (ModList.get().isLoaded("firstperson") || ModList.get().isLoaded("firstpersonmod")) {
                return;
            }
            Entity entity = RenderEntityEvents.getEntity(stack, (Level)level);
            if (entity != null) {
                Vec3 playerpos = CarryRenderHelper.getExactPos((Entity)player, partialticks);
                entity.m_6034_(playerpos.f_82479_, playerpos.f_82480_, playerpos.f_82481_);
                entity.f_19860_ = 0.0f;
                entity.f_19859_ = 0.0f;
                entity.m_5616_(0.0f);
                float height = entity.m_20206_();
                float width = entity.m_20205_();
                matrix.m_85836_();
                matrix.m_85841_(0.8f, 0.8f, 0.8f);
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                matrix.m_85837_(0.0, (double)(-height) - 0.1, (double)width + 0.1);
                if (perspective == 0) {
                    manager.m_114468_(false);
                    CarryOnOverride carryOverride = ScriptChecker.getOverride((Player)player);
                    if (carryOverride != null) {
                        CarryRenderHelper.performOverrideTransformation(matrix, carryOverride);
                        String entityname = carryOverride.getRenderNameEntity();
                        if (entityname != null) {
                            Entity newEntity = null;
                            Optional type = EntityType.m_20632_((String)entityname);
                            if (type.isPresent()) {
                                newEntity = ((EntityType)type.get()).m_20615_((Level)level);
                            }
                            if (newEntity != null) {
                                CompoundTag nbttag = carryOverride.getRenderNBT();
                                if (nbttag != null) {
                                    newEntity.deserializeNBT(nbttag);
                                }
                                entity = newEntity;
                                entity.m_6034_(playerpos.f_82479_, playerpos.f_82480_, playerpos.f_82481_);
                                entity.f_19860_ = 0.0f;
                                entity.f_19859_ = 0.0f;
                                entity.m_5616_(0.0f);
                            }
                        }
                    }
                    if (entity instanceof LivingEntity) {
                        ((LivingEntity)entity).f_20916_ = 0;
                    }
                    manager.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrix, buffer, light);
                    manager.m_114468_(true);
                }
                matrix.m_85849_();
                if (perspective == 0) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

