/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.helper.InvalidConfigException;
import tschipp.carryon.common.helper.StringParser;

public class ModelOverridesHandler {
    public static HashMap<CompoundTag, Object> OVERRIDE_OBJECTS = new HashMap();

    public static void parseOverride(String overrideString, int i) {
        Object overrideObject;
        BlockState toOverrideObject;
        boolean errored = false;
        CompoundTag tag = new CompoundTag();
        String currentline = overrideString;
        if (StringUtils.isEmpty((CharSequence)currentline) || !StringUtils.contains((CharSequence)currentline, (CharSequence)"->")) {
            new InvalidConfigException("Missing Override Model at line " + i + " : " + currentline).printException();
        }
        String[] sa = currentline.split("->");
        String toOverride = "";
        String override = "";
        try {
            toOverride = sa[0];
            override = sa[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            errored = true;
            new InvalidConfigException("Missing Override Model at line " + i + " : " + currentline).printException();
        }
        if (toOverride.contains("{")) {
            if (!toOverride.contains("}")) {
                errored = true;
                new InvalidConfigException("Missing } at line " + i + " : " + currentline).printException();
            }
            String nbt = toOverride.substring(toOverride.indexOf("{"));
            toOverride = toOverride.replace(nbt, "");
            try {
                tag = TagParser.m_129359_((String)nbt);
            }
            catch (Exception e) {
                errored = true;
                new InvalidConfigException("Error while parsing NBT at line " + i + " : " + e.getMessage()).printException();
            }
        } else if (toOverride.contains("}")) {
            errored = true;
            new InvalidConfigException("Missing { at line " + i + " : " + currentline).printException();
        }
        String overridetype = "item";
        if (override.contains("(")) {
            if (!override.contains(")")) {
                errored = true;
                new InvalidConfigException("Missing ) at line " + i + " : " + currentline).printException();
            }
            overridetype = override.substring(0, override.indexOf(")") + 1);
            override = override.replace(overridetype, "");
            overridetype = overridetype.replace("(", "");
            overridetype = overridetype.replace(")", "");
        } else if (override.contains(")")) {
            errored = true;
            new InvalidConfigException("Missing ( at line " + i + " : " + currentline).printException();
        }
        String modidToOverride = "minecraft";
        String modidOverride = "minecraft";
        if (toOverride.contains(":")) {
            modidToOverride = toOverride.replace(toOverride.substring(toOverride.indexOf(":")), "");
        }
        if (override.contains(":")) {
            modidOverride = override.replace(override.substring(override.indexOf(":")), "");
        }
        if ((ModList.get().isLoaded(modidOverride) || modidOverride.equals("minecraft")) && (ModList.get().isLoaded(modidToOverride) || modidToOverride.equals("minecraft")) && !errored && (toOverrideObject = StringParser.getBlockState(toOverride)) != null && (overrideObject = overridetype.equals("block") ? StringParser.getBlockState(override) : StringParser.getItemStack(override)) != null) {
            CompoundTag keyComp = new CompoundTag();
            keyComp.m_128365_("nbttag", (Tag)tag);
            if (toOverrideObject instanceof Block) {
                keyComp.m_128359_("block", ForgeRegistries.BLOCKS.getKey((Object)((Block)toOverrideObject)).toString());
            } else {
                keyComp.m_128405_("stateid", Block.m_49956_((BlockState)toOverrideObject));
                keyComp.m_128359_("block", ForgeRegistries.BLOCKS.getKey((Object)toOverrideObject.m_60734_()).toString());
            }
            OVERRIDE_OBJECTS.put(keyComp, overrideObject);
        }
    }

    public static void initOverrides() {
        List overrides = (List)Configs.ModelOverrides.modelOverrides.get();
        for (int i = 0; i < overrides.size(); ++i) {
            ModelOverridesHandler.parseOverride((String)overrides.get(i), i);
        }
    }

    public static boolean hasCustomOverrideModel(BlockState state, CompoundTag tag) {
        if (OVERRIDE_OBJECTS.isEmpty()) {
            return false;
        }
        int stateid = Block.m_49956_((BlockState)state);
        CompoundTag[] keys = new CompoundTag[OVERRIDE_OBJECTS.size()];
        OVERRIDE_OBJECTS.keySet().toArray(keys);
        for (CompoundTag key : keys) {
            int id = key.m_128451_("stateid");
            Block block = StringParser.getBlock(key.m_128461_("block"));
            if (!(id == 0 ? block == state.m_60734_() : id == stateid)) continue;
            CompoundTag toCheckForCompound = key.m_128469_("nbttag");
            Set kSetToCheck = toCheckForCompound.m_128431_();
            Set kSetTile = tag.m_128431_();
            boolean flag = true;
            if (!kSetTile.containsAll(kSetToCheck)) continue;
            for (String skey : kSetToCheck) {
                if (NbtUtils.m_129235_((Tag)tag.m_128423_(skey), (Tag)toCheckForCompound.m_128423_(skey), (boolean)true)) continue;
                flag = false;
            }
            if (!flag) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BakedModel getCustomOverrideModel(BlockState state, CompoundTag tag, Level level, Player player) {
        int stateid = Block.m_49956_((BlockState)state);
        CompoundTag[] keys = new CompoundTag[OVERRIDE_OBJECTS.size()];
        OVERRIDE_OBJECTS.keySet().toArray(keys);
        for (CompoundTag key : keys) {
            int id = key.m_128451_("stateid");
            Block block = StringParser.getBlock(key.m_128461_("block"));
            if (!(id == 0 ? block == state.m_60734_() : id == stateid)) continue;
            CompoundTag toCheckForCompound = key.m_128469_("nbttag");
            Set kSetToCheck = toCheckForCompound.m_128431_();
            Set kSetTile = tag.m_128431_();
            boolean flag = true;
            if (!kSetTile.containsAll(kSetToCheck)) continue;
            for (String skey : kSetToCheck) {
                if (NbtUtils.m_129235_((Tag)tag.m_128423_(skey), (Tag)toCheckForCompound.m_128423_(skey), (boolean)true)) continue;
                flag = false;
            }
            if (!flag) continue;
            Object override = OVERRIDE_OBJECTS.get(key);
            if (override == null) {
                return null;
            }
            if (override instanceof BlockState) {
                return Minecraft.m_91087_().m_91289_().m_110910_((BlockState)override);
            }
            return Minecraft.m_91087_().m_91291_().m_174264_((ItemStack)override, level, (LivingEntity)player, 0);
        }
        return null;
    }

    public static Object getOverrideObject(BlockState state, CompoundTag tag) {
        int stateid = Block.m_49956_((BlockState)state);
        CompoundTag[] keys = new CompoundTag[OVERRIDE_OBJECTS.size()];
        OVERRIDE_OBJECTS.keySet().toArray(keys);
        for (CompoundTag key : keys) {
            int id = key.m_128451_("stateid");
            Block block = StringParser.getBlock(key.m_128461_("block"));
            if (!(id == 0 ? block == state.m_60734_() : id == stateid)) continue;
            CompoundTag toCheckForCompound = key.m_128469_("nbttag");
            Set kSetToCheck = toCheckForCompound.m_128431_();
            Set kSetTile = tag.m_128431_();
            boolean flag = true;
            if (!kSetTile.containsAll(kSetToCheck)) continue;
            for (String skey : kSetToCheck) {
                if (NbtUtils.m_129235_((Tag)tag.m_128423_(skey), (Tag)toCheckForCompound.m_128423_(skey), (boolean)true)) continue;
                flag = false;
            }
            if (!flag) continue;
            return OVERRIDE_OBJECTS.get(key);
        }
        return null;
    }
}

