/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.item;

import java.lang.reflect.Method;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.event.ItemEvents;

public class ItemCarryonEntity
extends Item {
    private static final Method initGoals = ObfuscationReflectionHelper.findMethod(Mob.class, (String)"m_8099_", (Class[])new Class[0]);
    public static final String ENTITY_DATA_KEY = "entityData";

    public ItemCarryonEntity() {
        super(new Item.Properties().m_41487_(1));
    }

    public Component m_7626_(ItemStack stack) {
        if (ItemCarryonEntity.hasEntityData(stack)) {
            return Component.m_237115_((String)ItemCarryonEntity.getEntityType(stack).m_20675_());
        }
        return Component.m_237113_((String)"");
    }

    public static boolean hasEntityData(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128441_(ENTITY_DATA_KEY) && tag.m_128441_("entity");
        }
        return false;
    }

    public static boolean storeEntityData(@Nonnull Entity entity, Level level, ItemStack stack) {
        CompoundTag tag;
        if (entity == null || stack.m_41619_()) {
            return false;
        }
        CompoundTag entityData = new CompoundTag();
        entity.m_20240_(entityData);
        String name = EntityType.m_20613_((EntityType)entity.m_6095_()).toString();
        CompoundTag compoundTag = tag = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        if (tag.m_128441_(ENTITY_DATA_KEY)) {
            return false;
        }
        tag.m_128365_(ENTITY_DATA_KEY, (Tag)entityData);
        tag.m_128359_("entity", name);
        stack.m_41751_(tag);
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        ItemStack stack = context.m_43722_();
        BlockState state = level.m_8055_(pos);
        if (ModList.get().isLoaded("betterplacement") && CarryOnKeybinds.isKeyPressed(player)) {
            return InteractionResult.FAIL;
        }
        if (ItemCarryonEntity.hasEntityData(stack)) {
            Entity entity;
            BlockPos finalPos = pos;
            if (!state.m_60629_(new BlockPlaceContext(context))) {
                finalPos = pos.m_121945_(facing);
            }
            if ((entity = ItemCarryonEntity.getEntity(stack, level)) != null) {
                if (!level.f_46443_) {
                    entity.m_19890_((double)finalPos.m_123341_() + 0.5, (double)finalPos.m_123342_(), (double)finalPos.m_123343_() + 0.5, 180.0f + player.f_20885_, 0.0f);
                    level.m_7967_(entity);
                    if (entity instanceof Mob) {
                        ((Mob)entity).m_8032_();
                    }
                    ItemCarryonEntity.clearEntityData(stack);
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    ItemEvents.sendPacket(player, 9, 0);
                }
                player.getPersistentData().m_128473_("overrideKey");
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemCarryonEntity.hasEntityData(stack)) {
            if (ItemCarryonEntity.getEntity(stack, level) == null) {
                stack = ItemStack.f_41583_;
            }
            if (entity instanceof LivingEntity) {
                if (!(entity instanceof Player && ((Boolean)Configs.Settings.slownessInCreative.get()).booleanValue() || !((Player)entity).m_7500_())) {
                    return;
                }
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 1, this.potionLevel(stack, level), false, false));
            }
        } else {
            stack = ItemStack.f_41583_;
        }
    }

    public static void clearEntityData(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            tag.m_128473_(ENTITY_DATA_KEY);
            tag.m_128473_("entity");
        }
    }

    public static CompoundTag getPersistentData(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128469_(ENTITY_DATA_KEY);
        }
        return null;
    }

    public static Entity getEntity(ItemStack stack, Level level) {
        if (level == null) {
            return null;
        }
        String name = ItemCarryonEntity.getEntityName(stack);
        CompoundTag e = ItemCarryonEntity.getPersistentData(stack);
        Optional type = EntityType.m_20632_((String)name);
        Entity entity = null;
        if (type.isPresent()) {
            entity = ((EntityType)type.get()).m_20615_(level);
        }
        if (entity != null) {
            try {
                if (entity instanceof Mob) {
                    initGoals.invoke((Object)entity, new Object[0]);
                }
                entity.deserializeNBT(e);
            }
            catch (Exception e1) {
                try {
                    entity.deserializeNBT(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return entity;
    }

    public static String getEntityName(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128461_("entity");
        }
        return null;
    }

    public static String getCustomName(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            if (tag.m_128441_("CustomName") && !tag.m_128461_("CustomName").isEmpty()) {
                return tag.toString();
            }
            return tag.toString();
        }
        return null;
    }

    public static EntityType<?> getEntityType(ItemStack stack) {
        CompoundTag tag;
        String name;
        Optional type;
        if (stack.m_41782_() && (type = EntityType.m_20632_((String)(name = (tag = stack.m_41783_()).m_128461_("entity")))).isPresent()) {
            return (EntityType)type.get();
        }
        return null;
    }

    private int potionLevel(ItemStack stack, Level level) {
        Entity e = ItemCarryonEntity.getEntity(stack, level);
        if (e == null) {
            return 1;
        }
        int i = (int)(e.m_20206_() * e.m_20205_());
        if (i > 4) {
            i = 4;
        }
        if (!((Boolean)Configs.Settings.heavyEntities.get()).booleanValue()) {
            i = 1;
        }
        double multiplier = (Double)Configs.Settings.entitySlownessMultiplier.get();
        return (int)(multiplier * (double)i);
    }

    static {
        initGoals.setAccessible(true);
    }
}

