/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.network.client;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import tschipp.carryon.CarryOn;
import tschipp.carryon.common.scripting.ScriptChecker;

public class CarrySlotPacket {
    public int slot;
    public int carryOverride = 0;
    public int entityid;

    public CarrySlotPacket(ByteBuf buf) {
        this.slot = buf.readInt();
        this.carryOverride = buf.readInt();
        this.entityid = buf.readInt();
    }

    public CarrySlotPacket(int slot, int entityid) {
        this.slot = slot;
        this.entityid = entityid;
    }

    public CarrySlotPacket(int slot, int entityid, int carryOverride) {
        this.slot = slot;
        this.carryOverride = carryOverride;
        this.entityid = entityid;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        buf.writeInt(this.carryOverride);
        buf.writeInt(this.entityid);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().setPacketHandled(true);
            ctx.get().enqueueWork(() -> {
                Entity e;
                Level level = CarryOn.proxy.getLevel();
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                if (level != null && (e = level.m_6815_(this.entityid)) instanceof Player) {
                    Player player = (Player)e;
                    if (this.slot >= 9) {
                        player.getPersistentData().m_128473_("carrySlot");
                        player.getPersistentData().m_128473_("overrideKey");
                    } else {
                        player.getPersistentData().m_128405_("carrySlot", this.slot);
                        if (this.carryOverride != 0) {
                            ScriptChecker.setCarryOnOverride(player, this.carryOverride);
                        }
                    }
                }
            });
        }
        return true;
    }
}

