/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.carry;

import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1311;
import net.minecraft.class_1321;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.config.ListHandler;
import tschipp.carryon.common.pickupcondition.PickupCondition;
import tschipp.carryon.common.pickupcondition.PickupConditionHandler;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.common.scripting.ScriptManager;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.platform.Services;

public class PickupHandler {
    public static boolean canCarryGeneral(class_3222 player, class_243 pos) {
        if (!player.method_6047().method_7960() || !player.method_6079().method_7960()) {
            return false;
        }
        if (player.method_19538().method_1022(pos) > Constants.COMMON_CONFIG.settings.maxDistance) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)player);
        if (carry.isCarrying()) {
            return false;
        }
        if (!carry.isKeyPressed()) {
            return false;
        }
        if (player.field_6012 == carry.getTick()) {
            return false;
        }
        return player.field_13974.method_14257() != class_1934.field_9219 && player.field_13974.method_14257() != class_1934.field_9216;
    }

    public static boolean tryPickUpBlock(class_3222 player, class_2338 pos, class_1937 level, @Nullable BiFunction<class_2680, class_2338, Boolean> pickupCallback) {
        boolean doPickup;
        if (!PickupHandler.canCarryGeneral(player, class_243.method_24953((class_2382)pos))) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)player);
        class_2586 blockEntity = level.method_8321(pos);
        class_2680 state = level.method_8320(pos);
        class_2487 nbt = null;
        if (blockEntity != null) {
            nbt = blockEntity.method_38243();
        }
        if (!ListHandler.isPermitted(state.method_26204())) {
            return false;
        }
        if (state.method_26214((class_1922)level, pos) == -1.0f && !player.method_7337()) {
            return false;
        }
        if (blockEntity == null && !Constants.COMMON_CONFIG.settings.pickupAllBlocks) {
            return false;
        }
        if (blockEntity != null && nbt.method_10545("Lock") && !nbt.method_10558("Lock").equals("")) {
            return false;
        }
        Optional<PickupCondition> cond = PickupConditionHandler.getPickupCondition(state);
        if (cond.isPresent() && !cond.get().isFulfilled(player)) {
            return false;
        }
        boolean bl = doPickup = pickupCallback == null ? true : pickupCallback.apply(state, pos);
        if (!doPickup) {
            return false;
        }
        Optional<CarryOnScript> result = ScriptManager.inspectBlock(state, level, pos, nbt);
        if (result.isPresent()) {
            CarryOnScript script = result.get();
            if (!script.fulfillsConditions(player)) {
                return false;
            }
            carry.setActiveScript(script);
            String cmd = script.scriptEffects().commandInit();
            if (!cmd.isEmpty()) {
                player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), "/execute as " + player.method_7334().getName() + " run " + cmd);
            }
        }
        carry.setBlock(state, blockEntity);
        level.method_8544(pos);
        level.method_8650(pos, false);
        CarryOnDataManager.setCarryData((class_1657)player, carry);
        level.method_8396(null, pos, state.method_26231().method_10596(), class_3419.field_15245, 1.0f, 0.5f);
        player.method_23667(class_1268.field_5808, true);
        return true;
    }

    public static boolean tryPickupEntity(class_3222 player, class_1297 entity, @Nullable Function<class_1297, Boolean> pickupCallback) {
        String cmd;
        boolean doPickup;
        Optional<PickupCondition> cond;
        block20: {
            block21: {
                if (!PickupHandler.canCarryGeneral(player, entity.method_19538())) {
                    return false;
                }
                if (entity.field_6008 != 0) {
                    return false;
                }
                if (entity instanceof class_1321) {
                    class_1321 tame = (class_1321)entity;
                    UUID owner = tame.method_6139();
                    UUID playerID = player.method_7334().getId();
                    if (owner != null && !owner.equals(playerID)) {
                        return false;
                    }
                }
                if (ListHandler.isPermitted(entity)) break block20;
                if (!(entity instanceof class_1296)) break block21;
                class_1296 ageableMob = (class_1296)entity;
                if (Constants.COMMON_CONFIG.settings.allowBabies && (ageableMob.method_5618() < 0 || ageableMob.method_6109())) break block20;
            }
            return false;
        }
        if (!player.method_7337()) {
            if (!Constants.COMMON_CONFIG.settings.pickupHostileMobs && entity.method_5864().method_5891() == class_1311.field_6302) {
                return false;
            }
            if (Constants.COMMON_CONFIG.settings.maxEntityHeight < (double)entity.method_17682() || Constants.COMMON_CONFIG.settings.maxEntityWidth < (double)entity.method_17681()) {
                return false;
            }
        }
        if ((cond = PickupConditionHandler.getPickupCondition(entity)).isPresent() && !cond.get().isFulfilled(player)) {
            return false;
        }
        boolean bl = doPickup = pickupCallback == null ? true : pickupCallback.apply(entity);
        if (!doPickup) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)player);
        Optional<CarryOnScript> result = ScriptManager.inspectEntity(entity);
        if (result.isPresent()) {
            CarryOnScript script = result.get();
            if (!script.fulfillsConditions(player)) {
                return false;
            }
            carry.setActiveScript(script);
        }
        if (entity instanceof class_1657) {
            String cmd2;
            class_1657 otherPlayer = (class_1657)entity;
            if (!Constants.COMMON_CONFIG.settings.pickupPlayers) {
                return false;
            }
            if (!player.method_7337() && otherPlayer.method_7337()) {
                return false;
            }
            otherPlayer.method_5772();
            otherPlayer.method_5848();
            if (result.isPresent() && !(cmd2 = result.get().scriptEffects().commandInit()).isEmpty()) {
                player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), "/execute as " + player.method_7334().getName() + " run " + cmd2);
            }
            otherPlayer.method_5804((class_1297)player);
            Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_START_RIDING, new ClientboundStartRidingPacket(otherPlayer.method_5628(), true), player);
            carry.setCarryingPlayer();
            player.method_23667(class_1268.field_5808, true);
            player.field_6002.method_8396(null, player.method_23312(), class_3417.field_14883, class_3419.field_15256, 1.0f, 0.5f);
            CarryOnDataManager.setCarryData((class_1657)player, carry);
            return true;
        }
        entity.method_5772();
        entity.method_5848();
        if (entity instanceof class_1429) {
            class_1429 animal = (class_1429)entity;
            animal.method_5932(true, true);
        }
        if (result.isPresent() && !(cmd = result.get().scriptEffects().commandInit()).isEmpty()) {
            player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), "/execute as " + player.method_7334().getName() + " run " + cmd);
        }
        carry.setEntity(entity);
        entity.method_5650(class_1297.class_5529.field_27001);
        player.field_6002.method_8396(null, player.method_23312(), class_3417.field_14883, class_3419.field_15256, 1.0f, 0.5f);
        CarryOnDataManager.setCarryData((class_1657)player, carry);
        player.method_23667(class_1268.field_5808, true);
        return true;
    }
}

