/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.render;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;

public class CarryRenderHelper {
    public static class_243 getExactPos(class_1297 entity, float partialticks) {
        return new class_243(entity.field_6038 + (entity.method_23317() - entity.field_6038) * (double)partialticks, entity.field_5971 + (entity.method_23318() - entity.field_5971) * (double)partialticks, entity.field_5989 + (entity.method_23321() - entity.field_5989) * (double)partialticks);
    }

    public static float getExactBodyRotationDegrees(class_1309 entity, float partialticks) {
        class_1297 class_12972;
        if (entity.method_5854() != null && (class_12972 = entity.method_5854()) instanceof class_1309) {
            class_1309 vehicle = (class_1309)class_12972;
            if (vehicle instanceof class_1657) {
                class_1657 player = (class_1657)vehicle;
                return -(player.field_6220 + (player.field_6283 - player.field_6220) * partialticks);
            }
            return -(entity.field_6259 + (entity.field_6241 - entity.field_6259) * partialticks);
        }
        return -(entity.field_6220 + (entity.field_6283 - entity.field_6220) * partialticks);
    }

    public static Quaternionf getExactBodyRotation(class_1309 entity, float partialticks) {
        return class_7833.field_40716.rotationDegrees(CarryRenderHelper.getExactBodyRotationDegrees(entity, partialticks));
    }

    public static void applyGeneralTransformations(class_1657 player, float partialticks, class_4587 matrix) {
        int perspective = CarryRenderHelper.getPerspective();
        Quaternionf playerrot = CarryRenderHelper.getExactBodyRotation((class_1309)player, partialticks);
        class_243 playerpos = CarryRenderHelper.getExactPos((class_1297)player, partialticks);
        class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
        class_243 offset = playerpos.method_1020(cameraPos);
        class_4050 pose = player.method_18376();
        matrix.method_22903();
        matrix.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        if (perspective == 2) {
            playerrot.mul((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        }
        matrix.method_22907(playerrot);
        matrix.method_22903();
        matrix.method_22905(0.6f, 0.6f, 0.6f);
        if (perspective == 2) {
            matrix.method_22904(0.0, 0.0, -1.35);
        }
        if (CarryRenderHelper.doSneakCheck(player)) {
            matrix.method_22904(0.0, -0.4, 0.0);
        }
        if (pose == class_4050.field_18079) {
            float f = player.method_6024(partialticks);
            float f3 = player.method_5799() ? -90.0f - player.field_6004 : -90.0f;
            float f4 = class_3532.method_16439((float)f, (float)0.0f, (float)f3);
            if (perspective == 2) {
                matrix.method_22904(0.0, 0.0, 1.35);
                matrix.method_22907(class_7833.field_40714.rotationDegrees(f4));
            } else {
                matrix.method_22907(class_7833.field_40713.rotationDegrees(f4));
            }
            matrix.method_22904(0.0, -1.5, -1.848);
            if (perspective == 2) {
                matrix.method_22904(0.0, 0.0, 2.38);
            }
        }
        if (pose == class_4050.field_18077) {
            float f1 = (float)player.method_6003() + partialticks;
            float f2 = class_3532.method_15363((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!player.method_6123()) {
                if (perspective == 2) {
                    matrix.method_22904(0.0, 0.0, 1.35);
                }
                if (perspective == 2) {
                    matrix.method_22907(class_7833.field_40714.rotationDegrees(f2 * (-90.0f - player.field_6004)));
                } else {
                    matrix.method_22907(class_7833.field_40713.rotationDegrees(f2 * (-90.0f - player.field_6004)));
                }
            }
            class_243 viewVector = player.method_5828(partialticks);
            class_243 deltaMovement = player.method_18798();
            double d0 = deltaMovement.method_37268();
            double d1 = deltaMovement.method_37268();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (deltaMovement.field_1352 * viewVector.field_1352 + deltaMovement.field_1350 * viewVector.field_1350) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = deltaMovement.field_1352 * viewVector.field_1350 - deltaMovement.field_1350 * viewVector.field_1352;
                matrix.method_22907(class_7833.field_40716.rotation((float)(Math.signum(d3) * Math.acos(d2))));
            }
            if (perspective != 2) {
                matrix.method_22904(0.0, 0.0, -1.35);
            }
            matrix.method_22904(0.0, -0.2, 0.0);
        }
        matrix.method_22904(0.0, 1.6, 0.65);
    }

    public static void applyBlockTransformations(class_1657 player, float partialticks, class_4587 matrix, class_2248 block) {
        int perspective = CarryRenderHelper.getPerspective();
        CarryRenderHelper.applyGeneralTransformations(player, partialticks, matrix);
        if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(block)) {
            matrix.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        }
        float height = CarryRenderHelper.getRenderHeight(player);
        float offset = (height - 1.0f) / 1.2f;
        matrix.method_46416(0.0f, -offset, 0.0f);
    }

    public static void applyEntityTransformations(class_1657 player, float partialticks, class_4587 matrix, class_1297 entity) {
        int perspective = CarryRenderHelper.getPerspective();
        class_4050 pose = player.method_18376();
        CarryRenderHelper.applyGeneralTransformations(player, partialticks, matrix);
        if (perspective == 2) {
            matrix.method_22904(0.0, -1.6, 0.65);
        } else {
            matrix.method_22904(0.0, -1.6, -0.65);
        }
        matrix.method_22905(1.666f, 1.666f, 1.666f);
        float height = entity.method_17682();
        float width = entity.method_17681();
        float multiplier = height * width;
        entity.field_6036 = 0.0;
        entity.field_5982 = 0.0f;
        entity.method_5847(0.0f);
        entity.field_6014 = 0.0;
        entity.field_6004 = 0.0f;
        if (perspective == 2) {
            matrix.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        }
        matrix.method_22905((10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f);
        matrix.method_22904(0.0, (double)(height / 2.0f + -(height / 2.0f) + 1.0f), (double)width - 0.1 < 0.7 ? (double)width - 0.1 + (0.7 - ((double)width - 0.1)) : (double)width - 0.1);
        if (pose == class_4050.field_18079 || pose == class_4050.field_18077) {
            matrix.method_22907(class_7833.field_40713.rotationDegrees(90.0f));
            matrix.method_22904(0.0, -0.2 * (double)height, 0.0);
            if (pose == class_4050.field_18077) {
                matrix.method_22904(0.0, 0.0, 0.2);
            }
        }
    }

    public static void performScriptTransformation(class_4587 matrix, CarryOnScript script) {
        int perspective = CarryRenderHelper.getPerspective();
        CarryOnScript.ScriptRender render = script.scriptRender();
        class_243 translation = render.renderTranslation().getVec();
        class_243 rotation = render.renderRotation().getVec();
        class_243 scale = render.renderscale().getVec(1.0, 1.0, 1.0);
        Quaternionf rot = class_7833.field_40714.rotationDegrees((float)rotation.field_1352);
        rot.mul((Quaternionfc)class_7833.field_40716.rotationDegrees((float)rotation.field_1351));
        rot.mul((Quaternionfc)class_7833.field_40718.rotationDegrees((float)rotation.field_1350));
        matrix.method_22907(rot);
        matrix.method_22904(translation.field_1352, translation.field_1351, perspective == 1 && script.isBlock() ? -translation.field_1350 : translation.field_1350);
        matrix.method_22905((float)scale.field_1352, (float)scale.field_1351, (float)scale.field_1350);
    }

    public static void renderBakedModel(class_1799 stack, class_4587 matrix, class_4597 buffer, int light, class_1087 model) {
        try {
            class_918 renderer = class_310.method_1551().method_1480();
            renderer.method_23179(stack, class_811.field_4315, false, matrix, buffer, light, class_4608.field_21444, model);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class_2680 getRenderState(class_1657 player) {
        Either<class_1799, class_2680> renderObj;
        Optional<ModelOverride> ov;
        CarryOnScript.ScriptRender render;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        class_2680 state = carry.getBlock().method_26204().method_9564();
        if (carry.getActiveScript().isPresent() && (render = carry.getActiveScript().get().scriptRender()).renderNameBlock().isPresent()) {
            state = ((class_2248)class_7923.field_41175.method_29107(render.renderNameBlock().get())).method_9564();
        }
        if ((ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt())).isPresent() && (renderObj = ov.get().getRenderObject()).right().isPresent()) {
            state = (class_2680)renderObj.right().get();
        }
        return state;
    }

    public static class_1087 getRenderBlock(class_1657 player) {
        Either<class_1799, class_2680> renderObj;
        Optional<ModelOverride> ov;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        class_918 renderer = class_310.method_1551().method_1480();
        class_2680 state = CarryRenderHelper.getRenderState(player);
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        if (state.method_26217() != class_2464.field_11458 || model.method_4713() || model.method_4707(state, null, class_5819.method_43047()).size() <= 0) {
            class_1799 stack = new class_1799((class_1935)state.method_26204());
            model = renderer.method_4019(stack, player.field_6002, (class_1309)player, 0);
        }
        if ((ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt())).isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
            model = renderer.method_4019((class_1799)renderObj.left().get(), player.field_6002, (class_1309)player, 0);
        }
        return model;
    }

    public static class_1297 getRenderEntity(class_1657 player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        class_1297 entity = carry.getEntity(player.field_6002);
        if (carry.getActiveScript().isPresent()) {
            CarryOnScript script = carry.getActiveScript().get();
            CarryOnScript.ScriptRender render = script.scriptRender();
            if (render.renderNameEntity().isPresent()) {
                entity = ((class_1299)class_7923.field_41177.method_29107(render.renderNameEntity().get())).method_5883(player.field_6002);
            }
            if (render.renderNBT().isPresent()) {
                entity.method_5651(render.renderNBT().get());
            }
        }
        return entity;
    }

    public static float getRenderWidth(class_1657 player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            Either<class_1799, class_2680> renderObj;
            class_2680 state = CarryRenderHelper.getRenderState(player);
            class_265 shape = state.method_26218((class_1922)player.field_6002, player.method_24515());
            if (shape == null || shape.method_1110()) {
                return 1.0f;
            }
            Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
            if (ov.isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
                return 0.8f;
            }
            float width = (float)Math.abs(shape.method_1107().field_1320 - shape.method_1107().field_1323);
            return width;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            class_1297 entity = CarryRenderHelper.getRenderEntity(player);
            return entity.method_17681();
        }
        return 1.0f;
    }

    public static float getRenderHeight(class_1657 player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            Either<class_1799, class_2680> renderObj;
            class_2680 state = CarryRenderHelper.getRenderState(player);
            class_265 shape = state.method_26218((class_1922)player.field_6002, player.method_24515());
            if (shape == null || shape.method_1110()) {
                return 1.0f;
            }
            Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
            if (ov.isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
                return 0.5f;
            }
            float height = (float)Math.abs(shape.method_1107().field_1325 - shape.method_1107().field_1322);
            return height;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            class_1297 entity = CarryRenderHelper.getRenderEntity(player);
            return entity.method_17682();
        }
        return 1.0f;
    }

    public static int getPerspective() {
        boolean isThirdPerson = !class_310.method_1551().field_1690.method_31044().method_31034();
        boolean isThirdPersonReverse = class_310.method_1551().field_1690.method_31044().method_31035();
        if (!isThirdPerson && !isThirdPersonReverse) {
            return 0;
        }
        if (isThirdPerson && !isThirdPersonReverse) {
            return 1;
        }
        return 2;
    }

    public static boolean doSneakCheck(class_1657 player) {
        if (player.method_31549().field_7479) {
            return false;
        }
        return player.method_5715() || player.method_18276();
    }

    public static boolean isChest(class_2248 block) {
        return block == class_2246.field_10034 || block == class_2246.field_10443 || block == class_2246.field_10380;
    }
}

