/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.carry;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import tschipp.carryon.common.scripting.CarryOnScript;

public class CarryOnData {
    private CarryType type;
    private CompoundTag nbt;
    private boolean keyPressed = false;
    private CarryOnScript activeScript;
    private int selectedSlot = 0;

    public CarryOnData(CompoundTag data) {
        this.type = data.m_128441_("type") ? CarryType.valueOf(data.m_128461_("type")) : CarryType.INVALID;
        this.nbt = data;
        if (data.m_128441_("keyPressed")) {
            this.keyPressed = data.m_128471_("keyPressed");
        }
        if (data.m_128441_("activeScript")) {
            DataResult res = CarryOnScript.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)data.m_128423_("activeScript"));
            this.activeScript = (CarryOnScript)res.getOrThrow(false, s -> {
                throw new RuntimeException("Failed to decode activeScript during CarryOnData serialization: " + s);
            });
        }
        if (data.m_128441_("selected")) {
            this.selectedSlot = data.m_128451_("selected");
        }
    }

    public CompoundTag getNbt() {
        this.nbt.m_128359_("type", this.type.toString());
        this.nbt.m_128379_("keyPressed", this.keyPressed);
        if (this.activeScript != null) {
            DataResult res = CarryOnScript.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.activeScript);
            Tag tag = (Tag)res.getOrThrow(false, s -> {
                throw new RuntimeException("Failed to encode activeScript during CarryOnData serialization: " + s);
            });
            this.nbt.m_128365_("activeScript", tag);
        }
        this.nbt.m_128405_("selected", this.selectedSlot);
        return this.nbt;
    }

    public CompoundTag getContentNbt() {
        if (this.type == CarryType.BLOCK && this.nbt.m_128441_("block")) {
            return this.nbt.m_128469_("block");
        }
        if (this.type == CarryType.ENTITY && this.nbt.m_128441_("entity")) {
            return this.nbt.m_128469_("entity");
        }
        return null;
    }

    public void setBlock(BlockState state, @Nullable BlockEntity tile) {
        this.type = CarryType.BLOCK;
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        }
        CompoundTag stateData = NbtUtils.m_129202_((BlockState)state);
        this.nbt.m_128365_("block", (Tag)stateData);
        if (tile != null) {
            CompoundTag tileData = tile.m_187481_();
            this.nbt.m_128365_("tile", (Tag)tileData);
        }
    }

    public BlockState getBlock() {
        if (this.type != CarryType.BLOCK) {
            throw new IllegalStateException("Called getBlock on data that contained " + this.type);
        }
        return NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)this.nbt.m_128469_("block"));
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        if (this.type != CarryType.BLOCK) {
            throw new IllegalStateException("Called getBlockEntity on data that contained " + this.type);
        }
        if (!this.nbt.m_128441_("tile")) {
            return null;
        }
        return BlockEntity.m_155241_((BlockPos)pos, (BlockState)this.getBlock(), (CompoundTag)this.nbt.m_128469_("tile"));
    }

    public void setEntity(Entity entity) {
        this.type = CarryType.ENTITY;
        CompoundTag entityData = new CompoundTag();
        entity.m_20223_(entityData);
        this.nbt.m_128365_("entity", (Tag)entityData);
    }

    public Entity getEntity(Level level) {
        if (this.type != CarryType.ENTITY) {
            throw new IllegalStateException("Called getEntity on data that contained " + this.type);
        }
        return (Entity)EntityType.m_20642_((CompoundTag)this.nbt.m_128469_("entity"), (Level)level).orElseThrow(() -> new IllegalStateException("Called EntityType#create even though no entity data was present. Data: " + this.nbt.toString()));
    }

    public Optional<CarryOnScript> getActiveScript() {
        if (this.activeScript == null) {
            return Optional.empty();
        }
        return Optional.of(this.activeScript);
    }

    public void setActiveScript(CarryOnScript script) {
        this.activeScript = script;
    }

    public void setCarryingPlayer() {
        this.type = CarryType.PLAYER;
    }

    public boolean isCarrying() {
        return this.type != CarryType.INVALID;
    }

    public boolean isCarrying(CarryType type) {
        return this.type == type;
    }

    public boolean isKeyPressed() {
        return this.keyPressed;
    }

    public void setKeyPressed(boolean val) {
        this.keyPressed = val;
        this.nbt.m_128379_("keyPressed", val);
    }

    public void setSelected(int selectedSlot) {
        this.selectedSlot = selectedSlot;
    }

    public int getSelected() {
        return this.selectedSlot;
    }

    public void clear() {
        this.type = CarryType.INVALID;
        this.nbt = new CompoundTag();
        this.activeScript = null;
    }

    public int getTick() {
        if (!this.nbt.m_128441_("tick")) {
            return -1;
        }
        return this.nbt.m_128451_("tick");
    }

    public static enum CarryType {
        BLOCK,
        ENTITY,
        PLAYER,
        INVALID;

    }
}

