/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.puffish.castle.ForgeBlockParser;
import net.puffish.castle.ForgeGenerator;
import net.puffish.castle.config.Config;
import net.puffish.castle.config.Configuration;
import net.puffish.castle.config.Theme;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="castle_dungeons")
public class CastleDungeons {
    public static final String MOD_ID = "castle_dungeons";
    public static final Logger LOGGER = LogManager.getLogger((String)"castle_dungeons");
    public static final ResourceLocation LOOT_TABLE_LOOT = new ResourceLocation("castle_dungeons", "chests/loot");
    public static final ResourceLocation LOOT_TABLE_HEAL = new ResourceLocation("castle_dungeons", "chests/heal");
    public static final ResourceLocation LOOT_TABLE_JUNK = new ResourceLocation("castle_dungeons", "chests/junk");
    public static final IStructurePieceType CASTLE_TYPE = (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("castle_dungeons", "castle_piece"), ForgeGenerator.Piece::new);
    private static final ForgeGenerator GENERATOR = new ForgeGenerator();
    private static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"castle_dungeons");
    private static final StructureFeature<?, ?> CONFIGURED_STRUCTURE_GENERATOR = GENERATOR.func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_);
    private File configDirectory;
    private static final String[] files = new String[]{"themes/default.cfg", "themes/desert.cfg", "config.cfg"};
    private List<Theme<Block>> themes;
    private Config config;

    public CastleDungeons() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DEFERRED_REGISTRY_STRUCTURE.register(eventBus);
        DEFERRED_REGISTRY_STRUCTURE.register("castle", () -> GENERATOR);
        eventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onBiomeLoad);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onWorldLoad);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            this.configDirectory = new File(FMLPaths.CONFIGDIR.get().toFile(), "castle_dungeons/");
            if (!this.configDirectory.exists()) {
                this.configDirectory.mkdirs();
                Configuration.copyDefault(this.configDirectory, files);
            }
            this.themes = Configuration.loadThemes(this.configDirectory, new ForgeBlockParser());
            this.config = Configuration.loadConfig(this.configDirectory);
            if (this.config == null) {
                LOGGER.warn("Could not load config!");
                return;
            }
            LOGGER.info("Loaded " + String.valueOf(this.themes.size()) + " themes!");
            GENERATOR.initialize(this);
            Structure.field_236365_a_.put((Object)GENERATOR.getRegistryName().toString(), (Object)GENERATOR);
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add((Object)GENERATOR).build();
            StructureSeparationSettings structureSeparationSettings = new StructureSeparationSettings(this.config.getSpacing(), this.config.getSeparation(), 30042004);
            DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put((Object)GENERATOR, (Object)structureSeparationSettings).build();
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<ForgeGenerator, StructureSeparationSettings> tmpMap = new HashMap<ForgeGenerator, StructureSeparationSettings>(structureMap);
                    tmpMap.put(GENERATOR, structureSeparationSettings);
                    ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tmpMap;
                } else {
                    structureMap.put(GENERATOR, structureSeparationSettings);
                }
            });
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation(MOD_ID, "configured_castle"), CONFIGURED_STRUCTURE_GENERATOR);
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeLoad(BiomeLoadingEvent event) {
        event.getGeneration().getStructures().add(() -> CONFIGURED_STRUCTURE_GENERATOR);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<ForgeGenerator, Object> tempMap = new HashMap<ForgeGenerator, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(GENERATOR, DimensionStructuresSettings.field_236191_b_.get((Object)GENERATOR));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    public List<Theme<Block>> getThemes() {
        return this.themes;
    }

    public Config getConfig() {
        return this.config;
    }
}

