/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.ScatteredStructurePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.puffish.castle.CastleDungeons;
import net.puffish.castle.ForgeWorldEditor;
import net.puffish.castle.builder.Generator;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.config.Theme;

public class ForgeGenerator
extends Structure<NoFeatureConfig> {
    private ForgeGeneratorInternal internal;
    private CastleDungeons castleDungeons;

    public ForgeGenerator() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public void initialize(CastleDungeons castleDungeons) {
        if (this.castleDungeons == null) {
            this.castleDungeons = castleDungeons;
            this.internal = new ForgeGeneratorInternal(castleDungeons);
        }
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public static class Piece
    extends ScatteredStructurePiece {
        public Piece(int x, int y, int z) {
            super(CastleDungeons.CASTLE_TYPE, new Random(), x, y, z, 1, 1, 1);
        }

        public Piece(TemplateManager manager, CompoundNBT nbt) {
            super(CastleDungeons.CASTLE_TYPE, nbt);
        }

        public boolean func_230383_a_(ISeedReader seedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            return true;
        }
    }

    public class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> feature, int chunkX, int chunkZ, MutableBoundingBox box, int references, long seed) {
            super(feature, chunkX, chunkZ, box, references, seed);
        }

        public void generatePieces(DynamicRegistries dynamicRegistries, ChunkGenerator chunkGenerator, TemplateManager manager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            if (!ForgeGenerator.this.internal.hasThemeForBiome(ForgeGenerator.this.castleDungeons.getThemes(), dynamicRegistries, chunkGenerator.func_202090_b().func_225526_b_((chunkX << 2) + 8, 0, (chunkZ << 2) + 8))) {
                return;
            }
            int x = chunkX * 16 + 7;
            int z = chunkZ * 16 + 7;
            int y = chunkGenerator.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE_WG);
            if (y > ForgeGenerator.this.castleDungeons.getConfig().getMaxTerrainHeight()) {
                return;
            }
            if (y < ForgeGenerator.this.castleDungeons.getConfig().getMinTerrainHeight()) {
                return;
            }
            this.field_75075_a.add(new Piece(x, y, z));
            this.func_202500_a();
        }

        public void func_230366_a_(ISeedReader seedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos) {
            super.func_230366_a_(seedReader, structureManager, chunkGenerator, random, box, chunkPos);
            ServerWorld world = seedReader.func_201672_e();
            Biome biome = chunkGenerator.func_202090_b().func_225526_b_((chunkPos.field_77276_a << 2) + 8, 0, (chunkPos.field_77275_b << 2) + 8);
            Random tmpRandom = new Random(random.nextLong());
            world.func_73046_m().execute(() -> ForgeGenerator.this.internal.generate(world, chunkPos.field_77276_a, chunkPos.field_77275_b, biome, tmpRandom));
        }
    }

    private class ForgeGeneratorInternal
    extends Generator {
        private CastleDungeons castleDungeons;

        public ForgeGeneratorInternal(CastleDungeons castleDungeons) {
            super(castleDungeons.getConfig().getMinCastleSize(), castleDungeons.getConfig().getMaxCastleSize(), castleDungeons.getConfig().getSpawnerChance(), castleDungeons.getConfig().getChestChance());
            this.castleDungeons = castleDungeons;
        }

        public void generate(ServerWorld world, int chunkX, int chunkZ, Biome biome, Random random) {
            Theme<Block> theme = this.getThemeForBiome(this.castleDungeons.getThemes(), world.func_241828_r(), biome, random);
            if (theme == null) {
                CastleDungeons.LOGGER.warn("Could not find theme for biome!");
                return;
            }
            ForgeWorldEditor editor = new ForgeWorldEditor(this.castleDungeons, world, theme, random);
            this.generate(editor, chunkX, chunkZ, random);
        }

        @Override
        public int findGroundHeight(WorldEditor editor, int x, int z, int sizeX, int sizeZ) {
            ServerWorld world = ((ForgeWorldEditor)editor).getWorld();
            ChunkGenerator chunkGenerator = world.func_72863_F().func_201711_g();
            int height = 0;
            for (int i = 0; i < sizeX; ++i) {
                for (int j = 0; j < sizeX; ++j) {
                    height = Math.max(height, chunkGenerator.func_222532_b(x + i, z + j, Heightmap.Type.WORLD_SURFACE_WG));
                }
            }
            return height;
        }

        private String getBiomeName(DynamicRegistries dynamicRegistries, Biome biome) {
            ResourceLocation id = dynamicRegistries.func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
            if (id == null) {
                return "?";
            }
            return id.func_110624_b() + ":" + id.func_110623_a();
        }

        public <T> boolean hasThemeForBiome(List<Theme<T>> themes, DynamicRegistries dynamicRegistries, Biome biome) {
            return this.hasThemeForBiome(themes, this.getBiomeName(dynamicRegistries, biome));
        }

        public <T> Theme<T> getThemeForBiome(List<Theme<T>> themes, DynamicRegistries dynamicRegistries, Biome biome, Random random) {
            return this.getThemeForBiome(themes, this.getBiomeName(dynamicRegistries, biome), random);
        }
    }
}

