/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.puffish.castle.CastleDungeons;
import net.puffish.castle.builder.BlockGroup;
import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.ChestType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.EntityType;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.config.Theme;

public class ForgeWorldEditor
extends WorldEditor {
    private ServerWorld world;
    private Theme<Block> theme;
    private CastleDungeons castleDungeons;
    private Random random;
    private static final Block[] BEDS = new Block[]{Blocks.field_196587_am, Blocks.field_196588_an, Blocks.field_196589_ao, Blocks.field_196590_ap, Blocks.field_196592_aq, Blocks.field_196593_ar, Blocks.field_196594_as, Blocks.field_196595_at, Blocks.field_196596_au, Blocks.field_196597_av, Blocks.field_196598_aw, Blocks.field_196599_ax, Blocks.field_196600_ay, Blocks.field_196601_az, Blocks.field_196550_aA, Blocks.field_196551_aB};

    public ForgeWorldEditor(CastleDungeons castleDungeons, ServerWorld world, Theme<Block> theme, Random random) {
        this.castleDungeons = castleDungeons;
        this.world = world;
        this.theme = theme;
        this.random = random;
    }

    @Override
    public boolean setBlockIfEmpty(Coord coord, BlockType type) {
        BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
        if (this.world.func_180495_p(pos).func_200015_d((IBlockReader)this.world, pos)) {
            return false;
        }
        this.setBlock(coord, type);
        return true;
    }

    private void placeBed(Coord coord, Random random, Direction facing) {
        try {
            Block bedBlock = BEDS[random.nextInt(BEDS.length)];
            BlockState state = bedBlock.func_176223_P();
            state = (BlockState)state.func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD);
            state = (BlockState)state.func_206870_a((Property)BedBlock.field_185512_D, (Comparable)facing);
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.world.func_175656_a(pos, state);
            pos = pos.func_177972_a(facing.func_176734_d());
            state = bedBlock.func_176223_P();
            state = (BlockState)state.func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.FOOT);
            state = (BlockState)state.func_206870_a((Property)BedBlock.field_185512_D, (Comparable)facing);
            this.world.func_175656_a(pos, state);
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing bed");
        }
    }

    private void placeDoor(Coord coord, Block block, Direction facing) {
        try {
            BlockState state = block.func_176223_P();
            state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)facing);
            state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER);
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.world.func_175656_a(pos, state);
            pos = pos.func_177984_a();
            state = block.func_176223_P();
            state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)facing);
            state = (BlockState)state.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER);
            this.world.func_175656_a(pos, state);
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing door");
        }
    }

    @Override
    public BlockGroup createGroup() {
        return new ForgeBlockGroup(this.random.nextLong());
    }

    @Override
    public void setBlock(Coord coord, BlockType type, BlockGroup group) {
        Random random = null;
        random = group != null && group instanceof ForgeBlockGroup ? new Random(((ForgeBlockGroup)group).getSeed()) : this.random;
        try {
            switch (type) {
                case BED_NEGATIVE_X: {
                    this.placeBed(coord, random, Direction.EAST);
                    break;
                }
                case BED_NEGATIVE_Z: {
                    this.placeBed(coord, random, Direction.SOUTH);
                    break;
                }
                case BED_POSITIVE_X: {
                    this.placeBed(coord, random, Direction.WEST);
                    break;
                }
                case BED_POSITIVE_Z: {
                    this.placeBed(coord, random, Direction.NORTH);
                    break;
                }
                case DOOR_X: {
                    this.setBlock(coord, Blocks.field_150350_a);
                    this.setBlock(Coord.add(coord, 0, 1, 0), Blocks.field_150350_a);
                    if (random.nextInt(2) == 0) {
                        this.placeDoor(coord, this.getRandom(this.theme.getDoorBlocks(), random).getBlock(), Direction.EAST);
                        break;
                    }
                    this.placeDoor(coord, this.getRandom(this.theme.getDoorBlocks(), random).getBlock(), Direction.WEST);
                    break;
                }
                case DOOR_Y: {
                    this.setBlock(coord, Blocks.field_150350_a);
                    this.setBlock(Coord.add(coord, 0, 1, 0), Blocks.field_150350_a);
                    if (random.nextInt(2) == 0) {
                        this.placeDoor(coord, this.getRandom(this.theme.getDoorBlocks(), random).getBlock(), Direction.SOUTH);
                        break;
                    }
                    this.placeDoor(coord, this.getRandom(this.theme.getDoorBlocks(), random).getBlock(), Direction.NORTH);
                    break;
                }
                case WALL: {
                    this.setBlock(coord, this.getRandom(this.theme.getWallBlocks(), random));
                    break;
                }
                case WALL_FRAME: {
                    this.setBlock(coord, this.getRandom(this.theme.getWallFrameBlocks(), random));
                    break;
                }
                case FLOOR_0: {
                    this.setBlock(coord, this.getRandom(this.theme.getFloor0Blocks(), random));
                    break;
                }
                case FLOOR_1: {
                    this.setBlock(coord, this.getRandom(this.theme.getFloor1Blocks(), random));
                    break;
                }
                case PILLAR_0: {
                    this.setBlock(coord, this.getRandom(this.theme.getPillar0Blocks(), random));
                    break;
                }
                case PILLAR_1: {
                    this.setBlock(coord, this.getRandom(this.theme.getPillar1Blocks(), random));
                    break;
                }
                case FENCE_0: {
                    this.setBlock(coord, this.getRandom(this.theme.getFence0Blocks(), random));
                    break;
                }
                case FENCE_1: {
                    this.setBlock(coord, this.getRandom(this.theme.getFence1Blocks(), random));
                    break;
                }
                case ROOF_NEGATIVE_X: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.EAST, StairsShape.STRAIGHT);
                    break;
                }
                case ROOF_NEGATIVE_X_NEGATIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.SOUTH, StairsShape.OUTER_LEFT);
                    break;
                }
                case ROOF_NEGATIVE_X_POSITIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.NORTH, StairsShape.OUTER_RIGHT);
                    break;
                }
                case ROOF_NEGATIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.SOUTH, StairsShape.STRAIGHT);
                    break;
                }
                case ROOF_POSITIVE_X: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.WEST, StairsShape.STRAIGHT);
                    break;
                }
                case ROOF_POSITIVE_X_NEGATIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.SOUTH, StairsShape.OUTER_RIGHT);
                    break;
                }
                case ROOF_POSITIVE_X_POSITIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.NORTH, StairsShape.OUTER_LEFT);
                    break;
                }
                case ROOF_POSITIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.NORTH, StairsShape.STRAIGHT);
                    break;
                }
                case ROOF_TOP: {
                    this.setBlock(coord, this.getRandom(this.theme.getRoofSlabBlocks(), random));
                    break;
                }
                case STAIRS_0: {
                    this.setSlabBlock(coord, this.getRandom(this.theme.getSpiralStairsBlocks(), random), SlabType.BOTTOM);
                    break;
                }
                case STAIRS_1: {
                    this.setSlabBlock(coord, this.getRandom(this.theme.getSpiralStairsBlocks(), random), SlabType.TOP);
                    break;
                }
                case WINDOW: {
                    this.setBlock(coord, this.getRandom(this.theme.getWindowBlocks(), random));
                    break;
                }
                case CEIL: {
                    this.setBlock(coord, this.getRandom(this.theme.getCeilBlocks(), random));
                    break;
                }
                case FOUNDATION: {
                    this.setBlock(coord, this.getRandom(this.theme.getFoundationBlocks(), random));
                    break;
                }
                case STORAGE_ROOM_BLOCK: {
                    this.setBlock(coord, this.getRandom(this.theme.getStorageRoomBlocks(), random));
                    break;
                }
                case FURNACE_NEGATIVE_X: {
                    this.setFurnaceBlock(coord, Blocks.field_150460_al, Direction.WEST);
                    break;
                }
                case FURNACE_NEGATIVE_Z: {
                    this.setFurnaceBlock(coord, Blocks.field_150460_al, Direction.NORTH);
                    break;
                }
                case FURNACE_POSITIVE_X: {
                    this.setFurnaceBlock(coord, Blocks.field_150460_al, Direction.EAST);
                    break;
                }
                case FURNACE_POSITIVE_Z: {
                    this.setFurnaceBlock(coord, Blocks.field_150460_al, Direction.SOUTH);
                    break;
                }
                case ANVIL: {
                    this.setBlock(coord, Blocks.field_150467_bQ);
                    break;
                }
                case BOOKSHELF: {
                    this.setBlock(coord, Blocks.field_150342_X);
                    break;
                }
                case ENCHANTING_TABLE: {
                    this.setBlock(coord, Blocks.field_150381_bn);
                    break;
                }
                case EMPTY: {
                    this.setBlock(coord, Blocks.field_150350_a);
                    break;
                }
                case COBWEB: {
                    this.setBlock(coord, Blocks.field_196553_aF);
                    break;
                }
                case JAIL_BARS: {
                    this.setBlock(coord, Blocks.field_150411_aY);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Block getRandom(List<Block> blocks, Random random) {
        return blocks.get(random.nextInt(blocks.size()));
    }

    public void setBlock(Coord coord, Block block) {
        this.setBlockState(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), block.func_176223_P());
    }

    public void setFurnaceBlock(Coord coord, Block block, Direction facing) {
        try {
            BlockState state = block.func_176223_P();
            state = (BlockState)state.func_206870_a((Property)FurnaceBlock.field_220090_a, (Comparable)facing);
            this.setBlockState(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), state);
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing furnace");
        }
    }

    public void setStairsBlock(Coord coord, Block block, Direction facing, StairsShape shape) {
        try {
            BlockState state = block.func_176223_P();
            state = (BlockState)state.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)facing);
            state = (BlockState)state.func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)shape);
            this.setBlockState(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), state);
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing stairs");
        }
    }

    public void setSlabBlock(Coord coord, Block block, SlabType half) {
        try {
            BlockState state = block.func_176223_P();
            state = (BlockState)state.func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)half);
            this.setBlockState(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), state);
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing slab");
        }
    }

    @Override
    public void setChest(Coord coord, ChestType type, int level) {
        try {
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.setBlockState(pos, Blocks.field_150486_ae.func_176223_P());
            String lootTable = null;
            switch (type) {
                case LOOT: {
                    lootTable = this.theme.findLootChest(level);
                    break;
                }
                case HEAL: {
                    lootTable = this.theme.findHealChest(level);
                    break;
                }
                case JUNK: {
                    lootTable = this.theme.findJunkChest(level);
                }
            }
            long seed = this.random.nextLong();
            if (lootTable != null) {
                LockableLootTileEntity.func_195479_a((IBlockReader)this.world, (Random)new Random(seed), (BlockPos)pos, (ResourceLocation)new ResourceLocation(lootTable));
            }
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing chest");
        }
    }

    @Override
    public void setSpawner(Coord coord, int level) {
        try {
            CompoundNBT nbt;
            List<String> list = this.theme.findMobs(level);
            if (list == null) {
                return;
            }
            if (list.isEmpty()) {
                return;
            }
            String mob = list.get(this.random.nextInt(list.size()));
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.setBlockState(pos, Blocks.field_150474_ac.func_176223_P());
            MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)this.world.func_175625_s(pos);
            try {
                nbt = JsonToNBT.func_180713_a((String)this.castleDungeons.getConfig().getSpawnerLogic());
                spawner.func_145881_a().func_98270_a(nbt);
            }
            catch (Exception nbt2) {
                // empty catch block
            }
            nbt = null;
            int index = mob.indexOf("{");
            if (index == -1) {
                nbt = new CompoundNBT();
                nbt.func_74778_a("id", mob);
            } else {
                try {
                    nbt = JsonToNBT.func_180713_a((String)mob.substring(index, mob.length()));
                }
                catch (Exception e) {
                    nbt = new CompoundNBT();
                }
                nbt.func_74778_a("id", mob.substring(0, index));
            }
            WeightedSpawnerEntity entry = new WeightedSpawnerEntity(1, nbt);
            spawner.func_145881_a().func_184993_a(entry);
        }
        catch (Exception e) {
            CastleDungeons.LOGGER.warn("An error occurred while placing spawner!", (Throwable)e);
        }
    }

    @Override
    public void setSpawner(Coord coord, EntityType type) {
        try {
            CompoundNBT nbt2;
            String mob = null;
            switch (type) {
                case CAVE_SPIDER: {
                    mob = "minecraft:cave_spider";
                    break;
                }
                case ZOMBIE_VILLAGER: {
                    mob = "minecraft:zombie_villager";
                }
            }
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.setBlockState(pos, Blocks.field_150474_ac.func_176223_P());
            MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)this.world.func_175625_s(pos);
            try {
                nbt2 = JsonToNBT.func_180713_a((String)this.castleDungeons.getConfig().getSpawnerLogic());
                spawner.func_145881_a().func_98270_a(nbt2);
            }
            catch (Exception nbt2) {
                // empty catch block
            }
            nbt2 = new CompoundNBT();
            nbt2.func_74778_a("id", mob);
            WeightedSpawnerEntity entry = new WeightedSpawnerEntity(1, nbt2);
            spawner.func_145881_a().func_184993_a(entry);
        }
        catch (Exception e) {
            CastleDungeons.LOGGER.warn("An error occurred while placing spawner!", (Throwable)e);
        }
    }

    @Override
    public void spawnEntity(Coord coord, EntityType type) {
        Entity entity = null;
        switch (type) {
            case CAVE_SPIDER: {
                entity = net.minecraft.entity.EntityType.field_200794_h.func_200721_a((World)this.world);
                break;
            }
            case ZOMBIE_VILLAGER: {
                entity = net.minecraft.entity.EntityType.field_200727_aF.func_200721_a((World)this.world);
            }
        }
        if (entity != null) {
            entity.func_70107_b((double)coord.getX(), (double)coord.getY(), (double)coord.getZ());
            this.world.func_217376_c(entity);
        }
    }

    public void setBlockState(BlockPos pos, BlockState state) {
        this.world.func_175656_a(pos, state);
        if (!state.func_200015_d((IBlockReader)this.world, pos)) {
            this.updateBlock(pos.func_177982_a(1, 0, 0));
            this.updateBlock(pos.func_177982_a(0, 0, 1));
            this.updateBlock(pos.func_177982_a(-1, 0, 0));
            this.updateBlock(pos.func_177982_a(0, 0, -1));
        }
    }

    private void updateBlock(BlockPos pos) {
        BlockState state = this.world.func_180495_p(pos);
        state.func_241482_a_((IWorld)this.world, pos, 3, 512);
    }

    public ServerWorld getWorld() {
        return this.world;
    }

    private static class ForgeBlockGroup
    extends BlockGroup {
        private long seed;

        public ForgeBlockGroup(long seed) {
            this.seed = seed;
        }

        public long getSeed() {
            return this.seed;
        }
    }
}

