/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.ChestType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.RotatedWorldEditor;
import net.puffish.castle.builder.TranslatedWorldEditor;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.decorations.Chest;
import net.puffish.castle.builder.decorations.Spawner;
import net.puffish.castle.builder.nodes.ClearNode;
import net.puffish.castle.builder.nodes.HallwayNode;
import net.puffish.castle.builder.nodes.RoofNode;
import net.puffish.castle.builder.nodes.RoomNode;
import net.puffish.castle.builder.nodes.StairsNode;
import net.puffish.castle.builder.nodes.WalkNode;
import net.puffish.castle.builder.rooms.Room;
import net.puffish.castle.generator.Castle;
import net.puffish.castle.generator.CastleArea;
import net.puffish.castle.generator.CastleLayer;
import net.puffish.castle.generator.CastleNode;
import net.puffish.castle.generator.CastleNodeState;

public class Builder {
    private WorldEditor editor;
    private int spawnerChance;
    private int chestChance;

    public Builder(WorldEditor editor, int spawnerChance, int chestChance) {
        this.editor = editor;
        this.spawnerChance = spawnerChance;
        this.chestChance = chestChance;
    }

    public void buildCastle(Coord position, Castle castle, Random random) {
        int i;
        CastleNode node;
        TranslatedWorldEditor twe;
        Coord coord;
        int i2;
        position = Coord.add(position, 3, 0, 3);
        for (int i3 = 0; i3 < castle.getLayers().size(); ++i3) {
            CastleLayer layer = castle.getLayers().get(i3);
            for (int x = 0; x < castle.getWidth(); ++x) {
                for (int y = 0; y < castle.getHeight(); ++y) {
                    Coord coord2 = new Coord(x * 6 + position.getX(), i3 * 5 + position.getY(), y * 6 + position.getZ());
                    TranslatedWorldEditor twe2 = new TranslatedWorldEditor(this.editor, coord2);
                    CastleNode node2 = layer.getGrid()[x][y];
                    if (node2.getState() == CastleNodeState.EMPTY || node2.getState() == CastleNodeState.WALK) continue;
                    ClearNode clear = new ClearNode(twe2, castle, node2);
                    clear.build();
                }
            }
        }
        int[] hallwayCountOnLayer = new int[castle.getLayers().size()];
        ArrayList<Chest> chests = new ArrayList<Chest>();
        for (i2 = 0; i2 < castle.getLayers().size(); ++i2) {
            CastleLayer layer = castle.getLayers().get(i2);
            for (int x = 0; x < castle.getWidth(); ++x) {
                for (int y = 0; y < castle.getHeight(); ++y) {
                    HallwayNode hallway;
                    coord = new Coord(x * 6 + position.getX(), i2 * 5 + position.getY(), y * 6 + position.getZ());
                    twe = new TranslatedWorldEditor(this.editor, coord);
                    node = layer.getGrid()[x][y];
                    if (node.getState() == CastleNodeState.ROOF) {
                        RoofNode roof = new RoofNode(twe, castle, node);
                        roof.build();
                        continue;
                    }
                    if (node.getState() == CastleNodeState.TOWER) {
                        hallway = new HallwayNode(twe, castle, node);
                        hallway.build();
                        continue;
                    }
                    if (node.getState() == CastleNodeState.ROOM) {
                        RoomNode room = new RoomNode(twe, castle, node);
                        room.build();
                        continue;
                    }
                    if (node.getState() != CastleNodeState.HALLWAY) continue;
                    hallway = new HallwayNode(twe, castle, node);
                    hallway.build();
                    if (node.isStairs() || node.isStairsBelow()) continue;
                    int value = random.nextInt(Math.max(100, this.spawnerChance + this.chestChance));
                    if (value < this.spawnerChance) {
                        Spawner spawner = new Spawner(twe, castle, node);
                        spawner.build();
                    } else if (value < this.spawnerChance + this.chestChance) {
                        Chest chest = new Chest(twe, castle, node);
                        chests.add(chest);
                    }
                    int n = node.getLevel();
                    hallwayCountOnLayer[n] = hallwayCountOnLayer[n] + 1;
                }
            }
        }
        for (i2 = 0; i2 < castle.getLayers().size(); ++i2) {
            CastleLayer layer = castle.getLayers().get(i2);
            for (int x = 0; x < castle.getWidth(); ++x) {
                for (int y = 0; y < castle.getHeight(); ++y) {
                    coord = new Coord(x * 6 + position.getX(), i2 * 5 + position.getY(), y * 6 + position.getZ());
                    twe = new TranslatedWorldEditor(this.editor, coord);
                    node = layer.getGrid()[x][y];
                    if (node.getState() != CastleNodeState.WALK) continue;
                    WalkNode walk = new WalkNode(twe, castle, node);
                    walk.build();
                }
            }
        }
        for (i2 = 0; i2 < castle.getLayers().size(); ++i2) {
            CastleLayer layer = castle.getLayers().get(i2);
            for (int x = 0; x < castle.getWidth(); ++x) {
                for (int y = 0; y < castle.getHeight(); ++y) {
                    coord = new Coord(x * 6 + position.getX(), i2 * 5 + position.getY(), y * 6 + position.getZ());
                    twe = new TranslatedWorldEditor(this.editor, coord);
                    node = layer.getGrid()[x][y];
                    if (!node.isStairs()) continue;
                    StairsNode staris = new StairsNode(twe, castle, node);
                    staris.build();
                }
            }
        }
        for (i2 = 0; i2 < castle.getAreas().size(); ++i2) {
            CastleArea area = castle.getAreas().get(i2);
            if (!(area.getRoom() instanceof Room)) continue;
            Room room = (Room)area.getRoom();
            Coord coord3 = new Coord(area.getX() * 6 + position.getX(), area.getLevel() * 5 + position.getY(), area.getY() * 6 + position.getZ());
            RotatedWorldEditor rwe = new RotatedWorldEditor(this.editor, coord3, room.getWidth() * 6 - 1, room.getHeight() * 6 - 1, area.getRotation());
            room.build(rwe, random);
        }
        Collections.shuffle(chests, random);
        boolean[] lootChestOnLayer = new boolean[castle.getLayers().size()];
        int lootChestCount = 0;
        for (i = castle.getLayers().size() - 1; i >= 3; --i) {
            if (hallwayCountOnLayer[i] < 8) continue;
            lootChestOnLayer[i] = true;
            if (++lootChestCount >= 2) break;
        }
        for (i = 0; i < chests.size(); ++i) {
            Chest chest = (Chest)chests.get(i);
            int level = chest.getLevel();
            if (lootChestOnLayer[level]) {
                chest.setType(ChestType.LOOT);
                lootChestOnLayer[level] = false;
                ++lootChestCount;
            } else if ((double)random.nextFloat() < 0.4) {
                chest.setType(ChestType.HEAL);
            } else {
                chest.setType(ChestType.JUNK);
            }
            chest.build();
        }
    }

    public void buildFundation(Coord position, int width, int height) {
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < height; ++z) {
                int y = -1;
                while (this.editor.setBlockIfEmpty(Coord.add(position, x, y, z), BlockType.FOUNDATION)) {
                    --y;
                }
            }
        }
    }
}

