/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.puffish.castle.builder.Builder;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.rooms.BedRoom;
import net.puffish.castle.builder.rooms.BlacksmithRoom;
import net.puffish.castle.builder.rooms.JainRoom;
import net.puffish.castle.builder.rooms.LibraryRoom;
import net.puffish.castle.builder.rooms.SpiderRoom;
import net.puffish.castle.builder.rooms.StorageRoom;
import net.puffish.castle.config.Theme;
import net.puffish.castle.generator.Castle;

public abstract class Generator {
    private int minCastleSize;
    private int maxCastleSize;
    private int spawnerChance;
    private int chestChance;

    public Generator(int minCastleSize, int maxCastleSize, int spawnerChance, int chestChance) {
        this.minCastleSize = minCastleSize;
        this.maxCastleSize = maxCastleSize;
        this.spawnerChance = spawnerChance;
        this.chestChance = chestChance;
    }

    public void generate(WorldEditor editor, int chunkX, int chunkZ, Random random) {
        int x = random.nextInt(16) + chunkX * 16;
        int z = random.nextInt(16) + chunkZ * 16;
        int w = random.nextInt(this.maxCastleSize - this.minCastleSize + 1) + this.minCastleSize;
        int h = random.nextInt(this.maxCastleSize - this.minCastleSize + 1) + this.minCastleSize;
        Castle castle = new Castle(w, h);
        castle.addRoom(new LibraryRoom(1));
        castle.addRoom(new JainRoom(1));
        castle.addRoom(new SpiderRoom(2));
        castle.addRoom(new BlacksmithRoom(2));
        castle.addRoom(new BedRoom(6));
        castle.addRoom(new StorageRoom(10));
        castle.generate(random);
        int width = castle.getWidth() * 6 + 1;
        int height = castle.getHeight() * 6 + 1;
        Coord coord = new Coord(x - width / 2, 0, z - height / 2);
        coord.setY(this.findGroundHeight(editor, coord.getX(), coord.getZ(), width, height));
        Builder builder = new Builder(editor, this.spawnerChance, this.chestChance);
        builder.buildCastle(coord, castle, random);
        builder.buildFundation(coord, width, height);
    }

    public <T> boolean hasThemeForBiome(List<Theme<T>> themes, String biomeName) {
        for (Theme<T> t : themes) {
            if (t.getBiomeWhitelist() != null) {
                if (!t.getBiomeWhitelist().contains(biomeName)) continue;
                return true;
            }
            if (t.getBiomeBlacklist() != null) {
                if (t.getBiomeBlacklist().contains(biomeName)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public <T> Theme<T> getThemeForBiome(List<Theme<T>> themes, String biomeName, Random random) {
        ArrayList<Theme<T>> matchingThemes = new ArrayList<Theme<T>>();
        for (Theme<T> t : themes) {
            if (t.getBiomeWhitelist() != null) {
                if (!t.getBiomeWhitelist().contains(biomeName)) continue;
                matchingThemes.add(t);
                continue;
            }
            if (t.getBiomeBlacklist() != null) {
                if (t.getBiomeBlacklist().contains(biomeName)) continue;
                matchingThemes.add(t);
                continue;
            }
            matchingThemes.add(t);
        }
        if (matchingThemes.isEmpty()) {
            return null;
        }
        return (Theme)matchingThemes.get(random.nextInt(matchingThemes.size()));
    }

    public abstract int findGroundHeight(WorldEditor var1, int var2, int var3, int var4, int var5);
}

