/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder.nodes;

import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.nodes.Node;
import net.puffish.castle.generator.Castle;
import net.puffish.castle.generator.CastleNode;

public class StairsNode
extends Node {
    public StairsNode(WorldEditor editor, Castle castle, CastleNode node) {
        super(editor, castle, node);
    }

    @Override
    public void build() {
        for (int i = 1; i < 6; ++i) {
            this.buildStep(i);
        }
    }

    private void buildStep(int y) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                this.editor.setBlock(new Coord(x, y, z), BlockType.EMPTY);
            }
        }
        int i = (this.node.getLevel() * 5 + y) % 4;
        switch (i) {
            case 0: {
                this.editor.setBlock(new Coord(1, y, -1), BlockType.STAIRS_0);
                this.editor.setBlock(new Coord(0, y, -1), BlockType.STAIRS_1);
                break;
            }
            case 1: {
                this.editor.setBlock(new Coord(-1, y, -1), BlockType.STAIRS_0);
                this.editor.setBlock(new Coord(-1, y, 0), BlockType.STAIRS_1);
                break;
            }
            case 2: {
                this.editor.setBlock(new Coord(-1, y, 1), BlockType.STAIRS_0);
                this.editor.setBlock(new Coord(0, y, 1), BlockType.STAIRS_1);
                break;
            }
            case 3: {
                this.editor.setBlock(new Coord(1, y, 1), BlockType.STAIRS_0);
                this.editor.setBlock(new Coord(1, y, 0), BlockType.STAIRS_1);
            }
        }
    }
}

