/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder.rooms;

import java.util.Random;
import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.rooms.Room;

public class LibraryRoom
extends Room {
    public LibraryRoom(int maxCount) {
        super(2, 2, 2, maxCount);
        for (int i = 0; i < 2; ++i) {
            this.getConnection(0, 0, i).setNegativeX(true);
            this.getConnection(0, 0, i).setNegativeY(true);
            this.getConnection(1, 0, i).setPositiveX(true);
            this.getConnection(1, 0, i).setNegativeY(true);
            this.getConnection(0, 1, i).setNegativeX(true);
            this.getConnection(0, 1, i).setPositiveY(true);
            this.getConnection(1, 1, i).setPositiveX(true);
            this.getConnection(1, 1, i).setPositiveY(true);
        }
    }

    @Override
    public void build(WorldEditor editor, Random random) {
        int w = this.getWidthInBlocks();
        int h = this.getHeightInBlocks();
        for (int x = 0; x < w; ++x) {
            for (int z = 0; z < h; ++z) {
                editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_1);
                editor.setBlock(new Coord(x, 9, z), BlockType.CEIL);
                if (x < 2 || z < 2 || x > w - 2 - 1 || z > h - 2 - 1) {
                    editor.setBlock(new Coord(x, 5, z), BlockType.FLOOR_1);
                    if (x > 0 && z > 0 && x < w - 1 && z < h - 1) {
                        editor.setBlock(new Coord(x, 6, z), BlockType.FENCE_1);
                    }
                }
                if (x <= 0 || z <= 0 || x >= w - 1 || z >= h - 1 || z == 5 && x >= 4 && x <= 6 || z % 2 != 1) continue;
                for (int y = 1; y < 4; ++y) {
                    editor.setBlock(new Coord(x, y, z), BlockType.BOOKSHELF);
                }
            }
        }
        if (random.nextInt(4) == 0) {
            editor.setBlock(new Coord(5, 1, 5), BlockType.ENCHANTING_TABLE);
        }
    }
}

