/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder.rooms;

import java.util.Random;
import net.puffish.castle.builder.BlockGroup;
import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.rooms.Room;

public class StorageRoom
extends Room {
    private static final int[] heights = new int[]{3, 3, 1, 3, 3, 3, 2, 2, 2, 3, 1, 2, 3, 2, 1, 2, 2, 1, 2, 2, 2, 1, 0, 1, 2};

    public StorageRoom(int maxCount) {
        super(1, 1, 1, maxCount);
        this.getConnection(0, 0, 0).setNegativeX(true);
    }

    @Override
    public void build(WorldEditor editor, Random random) {
        int w = this.getWidthInBlocks();
        int h = this.getHeightInBlocks();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                editor.setBlock(new Coord(x, 0, y), BlockType.FLOOR_0);
                editor.setBlock(new Coord(x, 4, y), BlockType.CEIL);
            }
        }
        BlockGroup group = editor.createGroup();
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                this.buildPile(editor, group, x, z, heights[z + (4 - x) * 5], random);
            }
        }
    }

    private void buildPile(WorldEditor editor, BlockGroup group, int x, int z, int max, Random random) {
        if (max == 0) {
            return;
        }
        int h = random.nextInt(max);
        for (int y = 0; y < h; ++y) {
            editor.setBlock(new Coord(x, 1 + y, z), BlockType.STORAGE_ROOM_BLOCK, group);
        }
    }
}

