/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.config;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CfgFile {
    private HashMap<String, Item> map = new HashMap();
    private HashMap<String, String> defaultMap = new HashMap();
    private List<String> lines;
    private Path path;

    public CfgFile(File file) {
        this.path = file.toPath();
        if (!file.exists()) {
            this.lines = new ArrayList<String>();
            return;
        }
        try {
            this.lines = Files.readAllLines(this.path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int lineIndex = 0; lineIndex < this.lines.size(); ++lineIndex) {
            int pos;
            String line = this.lines.get(lineIndex).trim();
            if (line.startsWith("#") || line.isEmpty() || (pos = line.indexOf("=")) == -1) continue;
            String key = line.substring(0, pos).toLowerCase().trim();
            String value = line.substring(pos + 1, line.length()).trim();
            this.map.put(key, new Item(value, lineIndex));
        }
    }

    public String restoreDefault(String key) {
        String value = this.defaultMap.get(key);
        if (value == null) {
            return null;
        }
        Item item = this.map.get(key);
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        sb.append(" = ");
        sb.append(value);
        this.lines.set(item.getLine(), sb.toString());
        this.map.put(key, new Item(value, item.getLine()));
        return value;
    }

    public void setDefault(String key, int value) {
        this.setDefault(key, String.valueOf(value));
    }

    public void setDefault(String key, String value) {
        if (this.defaultMap.containsKey(key)) {
            Item item = this.map.get(key);
            StringBuilder sb = new StringBuilder();
            sb.append(key);
            sb.append(" = ");
            sb.append(value);
            this.lines.set(item.getLine(), sb.toString());
            this.map.put(key, new Item(value, item.getLine()));
        } else if (!this.map.containsKey(key)) {
            StringBuilder sb = new StringBuilder();
            sb.append(key);
            sb.append(" = ");
            sb.append(value);
            int lineIndex = this.lines.size();
            this.lines.add(sb.toString());
            this.map.put(key, new Item(value, lineIndex));
        }
        this.defaultMap.put(key, value);
    }

    public void set(String key, int value) {
        this.set(key, String.valueOf(value));
    }

    public void set(String key, String value) {
        if (this.map.containsKey(key)) {
            Item item = this.map.get(key);
            StringBuilder sb = new StringBuilder();
            sb.append(key);
            sb.append(" = ");
            sb.append(value);
            this.lines.set(item.getLine(), sb.toString());
            this.map.put(key, new Item(value, item.getLine()));
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(key);
            sb.append(" = ");
            sb.append(value);
            int lineIndex = this.lines.size();
            this.lines.add(sb.toString());
            this.map.put(key, new Item(value, lineIndex));
        }
    }

    public String getString(String key) {
        Item item = this.map.get(key);
        if (item == null) {
            String result = this.restoreDefault(key);
            if (result == null) {
                throw new RuntimeException();
            }
            return result;
        }
        return item.getValue();
    }

    public int getInt(String key) {
        try {
            return Integer.parseInt(this.map.get(key).getValue());
        }
        catch (Exception e) {
            String result = this.restoreDefault(key);
            if (result == null) {
                throw new RuntimeException();
            }
            return Integer.parseInt(result);
        }
    }

    public Set<String> keySet() {
        return new HashSet<String>(this.map.keySet());
    }

    public boolean has(String key) {
        return this.map.containsKey(key) || this.defaultMap.containsKey(key);
    }

    public void saveChanges() {
        try {
            Files.write(this.path, this.lines, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Item {
        private String value;
        private int line;

        public Item(String value, int line) {
            this.value = value;
            this.line = line;
        }

        public String getValue() {
            return this.value;
        }

        public int getLine() {
            return this.line;
        }
    }
}

