/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.puffish.castle.config.Config;
import net.puffish.castle.config.Theme;
import net.puffish.castle.config.parser.BlockParser;

public class Configuration {
    public static void copyDefault(File rootDirectory, String[] files) {
        for (String name : files) {
            try {
                int length;
                InputStream input = Configuration.class.getResourceAsStream("/resources/" + name);
                File file = new File(rootDirectory, name);
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                FileOutputStream output = new FileOutputStream(file);
                byte[] buffer = new byte[4096];
                while ((length = input.read(buffer)) != -1) {
                    ((OutputStream)output).write(buffer, 0, length);
                }
                ((OutputStream)output).close();
                input.close();
            }
            catch (Exception e) {
                System.out.println("Cound not copy file!");
                e.printStackTrace();
            }
        }
    }

    public static Config loadConfig(File rootDirectory) {
        File file = new File(rootDirectory, "config.cfg");
        return new Config(file);
    }

    public static <T> List<Theme<T>> loadThemes(File rootDirectory, BlockParser<T> blockParser) {
        ArrayList<Theme<T>> themes = new ArrayList<Theme<T>>();
        File themesDirectory = new File(rootDirectory, "themes/");
        if (!themesDirectory.exists()) {
            themesDirectory.mkdirs();
        }
        for (File file : themesDirectory.listFiles()) {
            Theme<T> theme = new Theme<T>(file, blockParser);
            if (theme == null) continue;
            themes.add(theme);
        }
        return themes;
    }
}

