/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.puffish.castle.config.CfgFile;
import net.puffish.castle.config.parser.BlockParser;

public class Theme<T> {
    private List<String> biomeWhitelist = null;
    private List<String> biomeBlacklist = null;
    private List<T> doorBlocks = null;
    private List<T> wallBlocks = null;
    private List<T> wallFrameBlocks = null;
    private List<T> pillar0Blocks = null;
    private List<T> pillar1Blocks = null;
    private List<T> floor0Blocks = null;
    private List<T> floor1Blocks = null;
    private List<T> fence0Blocks = null;
    private List<T> fence1Blocks = null;
    private List<T> ceilBlocks = null;
    private List<T> windowBlocks = null;
    private List<T> foundationBlocks = null;
    private List<T> spiralStairsBlocks = null;
    private List<T> roofStairsBlocks = null;
    private List<T> roofSlabBlocks = null;
    private List<T> storageRoomBlocks = null;
    private HashMap<Integer, List<String>> mobs = new HashMap();
    private HashMap<Integer, String> chestJunk = new HashMap();
    private HashMap<Integer, String> chestHeal = new HashMap();
    private HashMap<Integer, String> chestLoot = new HashMap();

    public Theme(File file, BlockParser<T> blockParser) {
        CfgFile cfg = new CfgFile(file);
        cfg.setDefault("wall", "");
        cfg.setDefault("wall-frame", "");
        cfg.setDefault("floor0", "");
        cfg.setDefault("floor1", "");
        cfg.setDefault("ceil", "");
        cfg.setDefault("pillar0", "");
        cfg.setDefault("pillar1", "");
        cfg.setDefault("fence0", "");
        cfg.setDefault("fence1", "");
        cfg.setDefault("window", "");
        cfg.setDefault("spiral-stair-slab", "");
        cfg.setDefault("roof-stair", "");
        cfg.setDefault("roof-slab", "");
        cfg.setDefault("storage-room-block", "");
        cfg.setDefault("door", "");
        cfg.setDefault("foundation", "");
        this.wallBlocks = this.splitAndParseBlock(blockParser, cfg.getString("wall"));
        this.wallFrameBlocks = this.splitAndParseBlock(blockParser, cfg.getString("wall-frame"));
        this.floor0Blocks = this.splitAndParseBlock(blockParser, cfg.getString("floor0"));
        this.floor1Blocks = this.splitAndParseBlock(blockParser, cfg.getString("floor1"));
        this.ceilBlocks = this.splitAndParseBlock(blockParser, cfg.getString("ceil"));
        this.pillar0Blocks = this.splitAndParseBlock(blockParser, cfg.getString("pillar0"));
        this.pillar1Blocks = this.splitAndParseBlock(blockParser, cfg.getString("pillar1"));
        this.fence0Blocks = this.splitAndParseBlock(blockParser, cfg.getString("fence0"));
        this.fence1Blocks = this.splitAndParseBlock(blockParser, cfg.getString("fence1"));
        this.windowBlocks = this.splitAndParseBlock(blockParser, cfg.getString("window"));
        this.spiralStairsBlocks = this.splitAndParseBlock(blockParser, cfg.getString("spiral-stair-slab"));
        this.roofStairsBlocks = this.splitAndParseBlock(blockParser, cfg.getString("roof-stair"));
        this.roofSlabBlocks = this.splitAndParseBlock(blockParser, cfg.getString("roof-slab"));
        this.storageRoomBlocks = this.splitAndParseBlock(blockParser, cfg.getString("storage-room-block"));
        this.doorBlocks = this.splitAndParseBlock(blockParser, cfg.getString("door"));
        this.foundationBlocks = this.splitAndParseBlock(blockParser, cfg.getString("foundation"));
        if (cfg.has("biome-whitelist")) {
            this.biomeWhitelist = this.splitAndParseString(cfg.getString("biome-whitelist"));
            if (this.biomeWhitelist.isEmpty()) {
                this.biomeWhitelist = null;
            }
        }
        if (cfg.has("biome-blacklist") && this.biomeWhitelist == null) {
            this.biomeBlacklist = this.splitAndParseString(cfg.getString("biome-blacklist"));
            if (this.biomeBlacklist.isEmpty()) {
                this.biomeBlacklist = null;
            }
        }
        this.parseMobs(cfg, this.mobs);
        this.parseChest(cfg, "junk", this.chestJunk);
        this.parseChest(cfg, "heal", this.chestHeal);
        this.parseChest(cfg, "loot", this.chestLoot);
        cfg.saveChanges();
    }

    private void parseChest(CfgFile cfg, String category, HashMap<Integer, String> map) {
        String prefix = "chest-" + category + "-";
        for (String key : cfg.keySet()) {
            if (!key.startsWith(prefix)) continue;
            int level = -1;
            try {
                level = Integer.parseInt(key.substring(prefix.length()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (level < 0) continue;
            map.put(level, cfg.getString(key));
        }
    }

    private void parseMobs(CfgFile cfg, HashMap<Integer, List<String>> map) {
        String prefix = "spawner-entities-";
        for (String key : cfg.keySet()) {
            if (!key.startsWith(prefix)) continue;
            int level = -1;
            try {
                level = Integer.parseInt(key.substring(prefix.length()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (level < 0) continue;
            map.put(level, this.splitAndParseString(cfg.getString(key)));
        }
    }

    private List<String> splitAndParseString(String str) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : Arrays.asList(str.split("\\s+"))) {
            if (name.isEmpty()) continue;
            list.add(name);
        }
        return list;
    }

    private List<T> splitAndParseBlock(BlockParser<T> blockParser, String str) {
        ArrayList<T> list = new ArrayList<T>();
        for (String name : Arrays.asList(str.split("\\s+"))) {
            if (name.isEmpty()) continue;
            T obj = blockParser.parseBlock(name);
            if (obj == null) {
                System.out.println("Could not parse block name! \"" + name + "\"");
                continue;
            }
            list.add(obj);
        }
        return list;
    }

    public String findJunkChest(int level) {
        return this.find(level, this.chestJunk);
    }

    public String findHealChest(int level) {
        return this.find(level, this.chestHeal);
    }

    public String findLootChest(int level) {
        return this.find(level, this.chestLoot);
    }

    public List<String> findMobs(int level) {
        return this.find(level, this.mobs);
    }

    private <V> V find(int level, HashMap<Integer, V> map) {
        while (level >= 0) {
            V value = map.get(level);
            if (value != null) {
                return value;
            }
            --level;
        }
        return null;
    }

    public List<T> getDoorBlocks() {
        return this.doorBlocks;
    }

    public List<String> getBiomeWhitelist() {
        return this.biomeWhitelist;
    }

    public List<String> getBiomeBlacklist() {
        return this.biomeBlacklist;
    }

    public List<T> getWallBlocks() {
        return this.wallBlocks;
    }

    public List<T> getWallFrameBlocks() {
        return this.wallFrameBlocks;
    }

    public List<T> getPillar0Blocks() {
        return this.pillar0Blocks;
    }

    public List<T> getPillar1Blocks() {
        return this.pillar1Blocks;
    }

    public List<T> getFloor0Blocks() {
        return this.floor0Blocks;
    }

    public List<T> getFloor1Blocks() {
        return this.floor1Blocks;
    }

    public List<T> getFence0Blocks() {
        return this.fence0Blocks;
    }

    public List<T> getFence1Blocks() {
        return this.fence1Blocks;
    }

    public List<T> getCeilBlocks() {
        return this.ceilBlocks;
    }

    public List<T> getWindowBlocks() {
        return this.windowBlocks;
    }

    public List<T> getFoundationBlocks() {
        return this.foundationBlocks;
    }

    public List<T> getSpiralStairsBlocks() {
        return this.spiralStairsBlocks;
    }

    public List<T> getRoofStairsBlocks() {
        return this.roofStairsBlocks;
    }

    public List<T> getRoofSlabBlocks() {
        return this.roofSlabBlocks;
    }

    public List<T> getStorageRoomBlocks() {
        return this.storageRoomBlocks;
    }
}

