/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.generator;

import net.puffish.castle.generator.Direction;
import net.puffish.castle.generator.Rotation;

public class CastleRoom {
    private int width;
    private int height;
    private int levels;
    private int maxCount;
    private Direction[][][] connections;

    public CastleRoom(int width, int height, int levels, int maxCount) {
        this.width = width;
        this.height = height;
        this.levels = levels;
        this.maxCount = maxCount;
        this.connections = new Direction[width][height][levels];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                for (int k = 0; k < levels; ++k) {
                    this.connections[i][j][k] = new Direction();
                }
            }
        }
    }

    public Direction getConnection(int x, int y, int level) {
        return this.connections[x][y][level];
    }

    public Direction getRotatedConnection(Rotation rotation, int x, int y, int level) {
        switch (rotation) {
            case DEGREES_0: {
                return this.rotate(this.connections[x][y][level], rotation);
            }
            case DEGREES_90: {
                return this.rotate(this.connections[y][this.height - x - 1][level], rotation);
            }
            case DEGREES_180: {
                return this.rotate(this.connections[this.width - x - 1][this.height - y - 1][level], rotation);
            }
            case DEGREES_270: {
                return this.rotate(this.connections[this.width - y - 1][x][level], rotation);
            }
        }
        return null;
    }

    private Direction rotate(Direction direction, Rotation rotation) {
        switch (rotation) {
            case DEGREES_0: {
                return new Direction(direction.isPositiveX(), direction.isPositiveY(), direction.isNegativeX(), direction.isNegativeY());
            }
            case DEGREES_90: {
                return new Direction(direction.isNegativeY(), direction.isPositiveX(), direction.isPositiveY(), direction.isNegativeX());
            }
            case DEGREES_180: {
                return new Direction(direction.isNegativeX(), direction.isNegativeY(), direction.isPositiveX(), direction.isPositiveY());
            }
            case DEGREES_270: {
                return new Direction(direction.isPositiveY(), direction.isNegativeX(), direction.isNegativeY(), direction.isPositiveX());
            }
        }
        return null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRotatedWidth(Rotation rotation) {
        if (rotation == Rotation.DEGREES_0 || rotation == Rotation.DEGREES_180) {
            return this.width;
        }
        return this.height;
    }

    public int getRotatedHeight(Rotation rotation) {
        if (rotation == Rotation.DEGREES_0 || rotation == Rotation.DEGREES_180) {
            return this.height;
        }
        return this.width;
    }

    public int getLevels() {
        return this.levels;
    }

    public int getMaxCount() {
        return this.maxCount;
    }
}

