/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.events;

import com.blackgear.cavesandcliffs.core.registries.CCBItems;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpyglassEvent {
    private static final ResourceLocation SPYGLASS_SCOPE_TEX_PATH = new ResourceLocation("cavesandcliffs", "textures/misc/spyglass_scope.png");
    private float scopeScale;

    @SubscribeEvent(priority=EventPriority.HIGH)
    @OnlyIn(value=Dist.CLIENT)
    public void renderSpyglassOverlay(RenderGameOverlayEvent event) {
        if (!event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
            int scaledWidth = event.getWindow().func_198107_o();
            int scaledHeight = event.getWindow().func_198087_p();
            ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
            float tickLength = Minecraft.func_71410_x().func_193989_ak();
            this.scopeScale = MathHelper.func_219799_g((float)(0.5f * tickLength), (float)this.scopeScale, (float)1.125f);
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                if (this.isScoping((PlayerEntity)playerEntity)) {
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.disableAlphaTest();
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(SPYGLASS_SCOPE_TEX_PATH);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder bufferBuilder = tessellator.func_178180_c();
                    float f5 = Math.min(scaledWidth, scaledHeight);
                    float f7 = Math.min((float)scaledWidth / f5, (float)scaledHeight / f5) * this.scopeScale;
                    float f8 = f5 * f7;
                    float f9 = f5 * f7;
                    float f10 = ((float)scaledWidth - f8) / 2.0f;
                    float f11 = ((float)scaledHeight - f9) / 2.0f;
                    float f12 = f10 + f8;
                    float f13 = f11 + f9;
                    bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    bufferBuilder.func_225582_a_((double)f10, (double)f13, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
                    bufferBuilder.func_225582_a_((double)f12, (double)f13, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
                    bufferBuilder.func_225582_a_((double)f12, (double)f11, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
                    bufferBuilder.func_225582_a_((double)f10, (double)f11, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
                    tessellator.func_78381_a();
                    RenderSystem.disableTexture();
                    bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    bufferBuilder.func_225582_a_(0.0, (double)scaledHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_((double)scaledWidth, (double)scaledHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_((double)scaledWidth, (double)f13, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_(0.0, (double)f13, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_(0.0, (double)f11, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_((double)scaledWidth, (double)f11, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_((double)scaledWidth, 0.0, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_(0.0, 0.0, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_(0.0, (double)f13, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_((double)f10, (double)f13, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_((double)f10, (double)f11, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_(0.0, (double)f11, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_((double)f12, (double)f13, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_((double)scaledWidth, (double)f13, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_((double)scaledWidth, (double)f11, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    bufferBuilder.func_225582_a_((double)f12, (double)f11, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
                    tessellator.func_78381_a();
                    RenderSystem.enableTexture();
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.enableDepthTest();
                    RenderSystem.enableAlphaTest();
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    this.scopeScale = 0.5f;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @OnlyIn(value=Dist.CLIENT)
    public void getFieldOfViewModifier(FOVUpdateEvent event) {
        ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
        if (playerEntity.func_184587_cr() && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && this.isScoping((PlayerEntity)playerEntity)) {
            event.setNewfov(0.1f);
        }
    }

    private boolean isScoping(PlayerEntity playerEntity) {
        return playerEntity.func_184587_cr() && playerEntity.func_184607_cu().func_77973_b().equals(CCBItems.SPYGLASS.get());
    }
}

