/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.particles;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlowParticle
extends SpriteTexturedParticle {
    private static final Random RANDOM = new Random();
    private final IAnimatedSprite spriteSet;

    protected GlowParticle(World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, IAnimatedSprite spriteSet) {
        super(worldIn, x, y, z, 0.5 - RANDOM.nextDouble(), ySpeed, 0.5 - RANDOM.nextDouble());
        this.spriteSet = spriteSet;
        this.field_187130_j *= (double)0.2f;
        if (xSpeed == 0.0 && zSpeed == 0.0) {
            this.field_187129_i *= (double)0.1f;
            this.field_187131_k *= (double)0.1f;
        }
        this.field_70544_f *= 0.75f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        if (RANDOM.nextBoolean()) {
            this.func_70538_b(0.6f, 1.0f, 0.8f);
        } else {
            this.func_70538_b(0.08f, 0.4f, 0.4f);
        }
        this.field_190017_n = false;
        this.func_217566_b(spriteSet);
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    protected int func_189214_a(float partialTick) {
        float age = ((float)this.field_70546_d + partialTick) / (float)this.field_70547_e;
        age = MathHelper.func_76131_a((float)age, (float)0.0f, (float)1.0f);
        int red = super.func_189214_a(partialTick);
        int green = red & 0xFF;
        int blue = red >> 16 & 0xFF;
        if ((green += (int)(age * 15.0f * 16.0f)) > 240) {
            green = 240;
        }
        return green | blue << 16;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        } else {
            this.func_217566_b(this.spriteSet);
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            if (this.field_187127_g == this.field_187124_d) {
                this.field_187129_i *= 1.1;
                this.field_187131_k *= 1.1;
            }
            this.field_187129_i *= (double)0.96f;
            this.field_187130_j *= (double)0.96f;
            this.field_187131_k *= (double)0.96f;
            if (this.field_187132_l) {
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new GlowParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

