/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.block;

import com.blackgear.cavesandcliffs.common.block.BigDripleafStemBlock;
import com.blackgear.cavesandcliffs.common.state.properties.CCBBlockStateProperties;
import com.blackgear.cavesandcliffs.common.state.properties.Tilt;
import com.blackgear.cavesandcliffs.common.util.block.BlockHelper;
import com.blackgear.cavesandcliffs.common.util.block.FluidHelper;
import com.blackgear.cavesandcliffs.common.util.math.CCBMathHelper;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BigDripleafBlock
extends HorizontalBlock
implements IGrowable,
IWaterLoggable {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final EnumProperty<Tilt> TILT = CCBBlockStateProperties.TILT;
    private static final Object2IntMap<Tilt> DELAY_UNTIL_NEXT_TILT_STATE = (Object2IntMap)Util.func_200696_a((Object)new Object2IntArrayMap(), delay -> {
        delay.defaultReturnValue(-1);
        delay.put((Object)Tilt.UNSTABLE, 20);
        delay.put((Object)Tilt.PARTIAL, 10);
        delay.put((Object)Tilt.FULL, 100);
    });
    private static final Map<Tilt, VoxelShape> LEAF_SHAPES = ImmutableMap.of((Object)((Object)Tilt.NONE), (Object)Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)((Object)Tilt.UNSTABLE), (Object)Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)((Object)Tilt.PARTIAL), (Object)Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), (Object)((Object)Tilt.FULL), (Object)VoxelShapes.func_197880_a());
    private static final Map<Direction, VoxelShape> STEM_SHAPES = ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)5.0, (double)0.0, (double)8.0, (double)11.0, (double)11.0, (double)14.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)11.0, (double)8.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)2.0, (double)0.0, (double)5.0, (double)8.0, (double)11.0, (double)11.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)8.0, (double)0.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0));
    private final Map<BlockState, VoxelShape> shapesCache;

    public BigDripleafBlock(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a(TILT, (Comparable)((Object)Tilt.NONE)));
        this.shapesCache = BlockHelper.getShapeForEachState((Block)this, BigDripleafBlock::calculatesShape);
    }

    protected static VoxelShape calculatesShape(BlockState state) {
        return VoxelShapes.func_197872_a((VoxelShape)BigDripleafBlock.getLeafShape(state), (VoxelShape)BigDripleafBlock.getStemShape(state));
    }

    private static VoxelShape getStemShape(BlockState state) {
        return STEM_SHAPES.get(state.func_177229_b((IProperty)field_185512_D));
    }

    private static VoxelShape getLeafShape(BlockState state) {
        return LEAF_SHAPES.get(state.func_177229_b(TILT));
    }

    protected static void placeWithRandomHeight(World worldIn, Random rand, BlockPos pos) {
        int count;
        int length = 1 + rand.nextInt(5);
        Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        BlockPos.Mutable mutable = new BlockPos.Mutable(pos);
        for (count = 0; count < length && BigDripleafBlock.canPlaceAt(worldIn, (BlockPos)mutable, worldIn.func_180495_p((BlockPos)mutable)); ++count) {
            mutable.func_189536_c(Direction.UP);
        }
        int height = pos.func_177956_o() + count - 1;
        mutable.func_185336_p(pos.func_177956_o());
        while (mutable.func_177956_o() < height) {
            BigDripleafStemBlock.place((IWorld)worldIn, (BlockPos)mutable, worldIn.func_204610_c((BlockPos)mutable), direction);
            mutable.func_189536_c(Direction.UP);
        }
        BigDripleafBlock.place(worldIn, (BlockPos)mutable, worldIn.func_204610_c((BlockPos)mutable), direction);
    }

    private static boolean canReplace(BlockState state) {
        return state.func_196958_f() || state.func_177230_c().equals(Blocks.field_150355_j) || state.func_177230_c().equals(CCBBlocks.SMALL_DRIPLEAF.get());
    }

    private static boolean canPlaceAt(World worldIn, BlockPos pos, BlockState state) {
        return !World.func_189509_E((BlockPos)pos) && BigDripleafBlock.canReplace(state);
    }

    protected static boolean place(World worldIn, BlockPos pos, IFluidState fluidState, Direction direction) {
        BlockState state = (BlockState)((BlockState)((Block)CCBBlocks.BIG_DRIPLEAF.get()).func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(FluidHelper.isSourceOfType(fluidState, (Fluid)Fluids.field_204546_a)))).func_206870_a((IProperty)field_185512_D, (Comparable)direction);
        return worldIn.func_180501_a(pos, state, 2);
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, Entity projectile) {
        this.setTiltAndScheduleTick(state, worldIn, hit.func_216350_a(), Tilt.FULL, SoundEvents.field_219626_bz);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        BlockState belowState = worldIn.func_180495_p(below);
        return belowState.func_177230_c().equals(CCBBlocks.BIG_DRIPLEAF_STEM.get()) || belowState.func_224755_d((IBlockReader)worldIn, below, Direction.UP);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_175655_b(currentPos, true);
        }
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        BlockState aboveState = worldIn.func_180495_p(pos.func_177984_a());
        return aboveState.func_196958_f() || aboveState.func_204520_s().func_206886_c().equals(FluidTags.field_206959_a);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockState aboveState;
        BlockPos above = pos.func_177984_a();
        if (BigDripleafBlock.canPlaceAt((World)worldIn, above, aboveState = worldIn.func_180495_p(above))) {
            Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
            BigDripleafStemBlock.place((IWorld)worldIn, pos, state.func_204520_s(), direction);
            BigDripleafBlock.place((World)worldIn, above, aboveState.func_204520_s(), direction);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K && state.func_177229_b(TILT) == Tilt.NONE && BigDripleafBlock.canEntityTilt(pos, entityIn)) {
            this.setTiltAndScheduleTick(state, worldIn, pos, Tilt.UNSTABLE, null);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_175640_z(pos)) {
            this.resetTilt(state, (World)worldIn, pos);
        } else {
            Tilt tilt = (Tilt)((Object)state.func_177229_b(TILT));
            if (tilt == Tilt.UNSTABLE) {
                this.setTiltAndScheduleTick(state, (World)worldIn, pos, Tilt.PARTIAL, SoundEvents.field_219626_bz);
            } else if (tilt == Tilt.PARTIAL) {
                this.setTiltAndScheduleTick(state, (World)worldIn, pos, Tilt.FULL, SoundEvents.field_219626_bz);
            } else if (tilt == Tilt.FULL) {
                this.resetTilt(state, (World)worldIn, pos);
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.func_175640_z(pos)) {
            this.resetTilt(state, worldIn, pos);
        }
    }

    private void playTiltSound(World worldIn, BlockPos pos, SoundEvent soundEvent) {
        float pitch = CCBMathHelper.randomBetween(worldIn.field_73012_v, 0.8f, 1.2f);
        worldIn.func_184133_a(null, pos, soundEvent, SoundCategory.BLOCKS, 1.0f, pitch);
    }

    private static boolean canEntityTilt(BlockPos pos, Entity entityIn) {
        return entityIn.func_226278_cu_() > (double)((float)pos.func_177956_o() + 0.6875f);
    }

    private void setTiltAndScheduleTick(BlockState state, World worldIn, BlockPos pos, Tilt tilt, @Nullable SoundEvent soundEvent) {
        int delay;
        this.setTilt(state, worldIn, pos, tilt);
        if (soundEvent != null) {
            this.playTiltSound(worldIn, pos, soundEvent);
        }
        if ((delay = DELAY_UNTIL_NEXT_TILT_STATE.getInt((Object)tilt)) != -1) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, delay);
        }
    }

    private void resetTilt(BlockState state, World worldIn, BlockPos pos) {
        this.setTilt(state, worldIn, pos, Tilt.NONE);
        this.playTiltSound(worldIn, pos, SoundEvents.field_219626_bz);
    }

    private void setTilt(BlockState state, World worldIn, BlockPos pos, Tilt tilt) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(TILT, (Comparable)((Object)tilt)), 2);
        if (tilt.causesVibration()) {
            // empty if block
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BigDripleafBlock.getLeafShape(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapesCache.get(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(FluidHelper.isSourceOfType(fluidState, (Fluid)Fluids.field_204546_a)))).func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED, field_185512_D, TILT});
    }
}

