/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.block;

import com.blackgear.cavesandcliffs.common.block.sound.CCBSoundEvents;
import com.blackgear.cavesandcliffs.common.block.util.AbstractCauldronBlock;
import com.blackgear.cavesandcliffs.common.util.CauldronInteraction;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class CCBCauldronBlock
extends AbstractCauldronBlock {
    public CCBCauldronBlock(Block.Properties properties) {
        super(properties, CauldronInteraction.EMPTY);
    }

    protected static boolean shouldHandlePrecipitation(World world) {
        return world.field_73012_v.nextInt(20) == 1;
    }

    @Override
    public void handlePrecipitation(BlockState state, World world, BlockPos pos, Biome.RainType precipitation) {
        if (CCBCauldronBlock.shouldHandlePrecipitation(world)) {
            if (precipitation == Biome.RainType.RAIN) {
                world.func_175656_a(pos, ((Block)CCBBlocks.WATER_CAULDRON.get()).func_176223_P());
            } else if (precipitation == Biome.RainType.SNOW) {
                world.func_175656_a(pos, ((Block)CCBBlocks.POWDER_SNOW_CAULDRON.get()).func_176223_P());
            }
        }
    }

    @Override
    public boolean canReceiveStalactiteDrip(Fluid fluid) {
        return true;
    }

    @Override
    protected void receiveStalactiteDrip(BlockState state, World worldIn, BlockPos pos, Fluid fluid) {
        if (fluid == Fluids.field_204546_a) {
            worldIn.func_175656_a(pos, ((Block)CCBBlocks.WATER_CAULDRON.get()).func_176223_P());
            worldIn.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.DRIPSTONE_DRIP_WATER_CAULDRON.get(), SoundCategory.BLOCKS, 2.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
        } else if (fluid == Fluids.field_204547_b) {
            worldIn.func_175656_a(pos, ((Block)CCBBlocks.LAVA_CAULDRON.get()).func_176223_P());
            worldIn.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.DRIPSTONE_DRIP_LAVA_CAULDRON.get(), SoundCategory.BLOCKS, 2.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }
}

