/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.block;

import com.blackgear.cavesandcliffs.common.block.CCBCauldronBlock;
import com.blackgear.cavesandcliffs.common.block.util.AbstractCauldronBlock;
import com.blackgear.cavesandcliffs.common.state.properties.CCBBlockStateProperties;
import com.blackgear.cavesandcliffs.common.util.CauldronInteraction;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class LayeredCauldronBlock
extends AbstractCauldronBlock {
    public static final IntegerProperty FLUID_LEVEL = CCBBlockStateProperties.LEVEL_CAULDRON;
    public static final Predicate<Biome.RainType> RAIN = precipitation -> precipitation == Biome.RainType.RAIN;
    public static final Predicate<Biome.RainType> SNOW = precipitation -> precipitation == Biome.RainType.SNOW;
    private final Predicate<Biome.RainType> fillPredicate;

    public LayeredCauldronBlock(Block.Properties properties, Predicate<Biome.RainType> fillPredicate, Map<Item, CauldronInteraction> interactions) {
        super(properties, interactions);
        this.fillPredicate = fillPredicate;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FLUID_LEVEL, (Comparable)Integer.valueOf(1)));
    }

    public boolean isFull(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)FLUID_LEVEL) == 3;
    }

    @Override
    public boolean canReceiveStalactiteDrip(Fluid fluid) {
        return fluid == Fluids.field_204546_a && this.fillPredicate == RAIN;
    }

    @Override
    protected double getContentHeight(BlockState state) {
        return (6.0 + (double)((Integer)state.func_177229_b((IProperty)FLUID_LEVEL)).intValue() * 3.0) / 16.0;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K && entityIn.func_70027_ad() && this.isEntityInsideContent(state, pos, entityIn)) {
            entityIn.func_70066_B();
            LayeredCauldronBlock.lowerFillLevel(state, worldIn, pos);
        }
    }

    public static void lowerFillLevel(BlockState state, World worldIn, BlockPos pos) {
        int levelValue = (Integer)state.func_177229_b((IProperty)FLUID_LEVEL) - 1;
        worldIn.func_175656_a(pos, levelValue == 0 ? Blocks.field_150383_bp.func_176223_P() : (BlockState)state.func_206870_a((IProperty)FLUID_LEVEL, (Comparable)Integer.valueOf(levelValue)));
    }

    @Override
    public void handlePrecipitation(BlockState state, World world, BlockPos pos, Biome.RainType precipitation) {
        if (CCBCauldronBlock.shouldHandlePrecipitation(world) && (Integer)state.func_177229_b((IProperty)FLUID_LEVEL) != 3 && this.fillPredicate.test(precipitation)) {
            world.func_175656_a(pos, (BlockState)state.func_177231_a((IProperty)FLUID_LEVEL));
            world.func_184133_a(null, pos, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, 2.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((IProperty)FLUID_LEVEL);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FLUID_LEVEL, field_176591_a});
    }

    @Override
    protected void receiveStalactiteDrip(BlockState state, World worldIn, BlockPos pos, Fluid fluid) {
        if (!this.isFull(state)) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)FLUID_LEVEL, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)FLUID_LEVEL) + 1)));
        }
    }
}

