/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.block;

import com.blackgear.cavesandcliffs.common.tags.CCBBlockTags;
import com.blackgear.cavesandcliffs.common.util.math.CCBMathHelper;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MossBlock
extends Block
implements IGrowable {
    public MossBlock(Block.Properties properties) {
        super(properties);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return worldIn.func_180495_p(pos.func_177984_a()).func_196958_f();
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        MossBlock.place((IWorld)worldIn, rand, pos.func_177984_a());
    }

    public static boolean place(IWorld worldIn, Random rand, BlockPos pos) {
        if (!worldIn.func_180495_p(pos).func_196958_f()) {
            return false;
        }
        int chance = 0;
        int xRandom = CCBMathHelper.randomBetweenInclusive(rand, 1, 3);
        int zRandom = CCBMathHelper.randomBetweenInclusive(rand, 1, 3);
        for (int x = -xRandom; x < xRandom; ++x) {
            for (int z = -zRandom; z < zRandom; ++z) {
                BlockPos position = pos.func_177982_a(x, 0, z);
                chance += MossBlock.placeFeature(worldIn, rand, position);
            }
        }
        return chance > 0;
    }

    private static int placeFeature(IWorld worldIn, Random rand, BlockPos pos) {
        int chance = 0;
        BlockPos below = pos.func_177977_b();
        BlockState stateBelow = worldIn.func_180495_p(below);
        if (worldIn.func_180495_p(pos).func_196958_f() && stateBelow.func_224755_d((IBlockReader)worldIn, below, Direction.UP)) {
            BlockState vegetationState;
            MossBlock.createMossPatch(worldIn, rand, pos.func_177977_b());
            if (rand.nextFloat() < 0.8f && (vegetationState = MossBlock.getVegetationBlockState(rand)).func_196955_c((IWorldReader)worldIn, pos)) {
                if (vegetationState.func_177230_c() instanceof DoublePlantBlock && worldIn.func_180495_p(pos).func_196958_f()) {
                    DoublePlantBlock doublePlantBlock = (DoublePlantBlock)vegetationState.func_177230_c();
                    doublePlantBlock.func_196390_a(worldIn, pos, 2);
                } else {
                    worldIn.func_180501_a(pos, vegetationState, 2);
                }
                ++chance;
            }
        }
        return chance;
    }

    private static void createMossPatch(IWorld worldIn, Random rand, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_203425_a(CCBBlockTags.LUSH_PLANTS_REPLACEABLE)) {
            worldIn.func_180501_a(pos, ((Block)CCBBlocks.MOSS_BLOCK.get()).func_176223_P(), 2);
        }
    }

    private static BlockState getVegetationBlockState(Random rand) {
        int chance = rand.nextInt(100) + 1;
        if (chance < 5) {
            return ((Block)CCBBlocks.FLOWERING_AZALEA.get()).func_176223_P();
        }
        if (chance < 15) {
            return ((Block)CCBBlocks.AZALEA.get()).func_176223_P();
        }
        if (chance < 40) {
            return ((Block)CCBBlocks.MOSS_CARPET.get()).func_176223_P();
        }
        return chance < 90 ? Blocks.field_150349_c.func_176223_P() : Blocks.field_196804_gh.func_176223_P();
    }
}

