/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.block;

import com.blackgear.cavesandcliffs.common.block.Fallable;
import com.blackgear.cavesandcliffs.common.block.sound.CCBSoundEvents;
import com.blackgear.cavesandcliffs.common.block.sound.CCBSoundType;
import com.blackgear.cavesandcliffs.common.block.util.AbstractCauldronBlock;
import com.blackgear.cavesandcliffs.common.state.properties.CCBBlockStateProperties;
import com.blackgear.cavesandcliffs.common.state.properties.DripstoneThickness;
import com.blackgear.cavesandcliffs.common.util.math.DirectionUtils;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PointedDripstoneBlock
extends Block
implements Fallable,
IWaterLoggable {
    public static final DirectionProperty TIP_DIRECTION = CCBBlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = CCBBlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public PointedDripstoneBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)TIP_DIRECTION, (Comparable)Direction.UP)).func_206870_a(THICKNESS, (Comparable)((Object)DripstoneThickness.TIP))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return PointedDripstoneBlock.isValidDripstonePlacement(worldIn, pos, (Direction)state.func_177229_b((IProperty)TIP_DIRECTION));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facing != Direction.UP && facing != Direction.DOWN) {
            return stateIn;
        }
        if (worldIn.func_205220_G_().func_205361_b(currentPos, (Object)this)) {
            return stateIn;
        }
        Direction direction = (Direction)stateIn.func_177229_b((IProperty)TIP_DIRECTION);
        if (facing == direction.func_176734_d() && !PointedDripstoneBlock.isValidDripstonePlacement((IWorldReader)worldIn, currentPos, direction)) {
            if (direction == Direction.DOWN) {
                this.scheduleStalactiteFallTicks(stateIn, worldIn, currentPos);
                return stateIn;
            }
            return this.getAirOrWater(stateIn);
        }
        boolean isMergedDripstone = stateIn.func_177229_b(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness thickness = PointedDripstoneBlock.calculateDripstoneThickness((IWorldReader)worldIn, currentPos, direction, isMergedDripstone);
        return thickness == null ? this.getAirOrWater(stateIn) : (BlockState)stateIn.func_206870_a(THICKNESS, (Comparable)((Object)thickness));
    }

    private BlockState getAirOrWater(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P();
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, Entity projectile) {
        if (projectile instanceof TridentEntity && projectile.func_213322_ci().func_72433_c() > 0.6) {
            worldIn.func_175655_b(hit.func_216350_a(), true);
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        BlockState state = worldIn.func_180495_p(pos);
        if (state.func_177229_b((IProperty)TIP_DIRECTION) == Direction.UP && state.func_177229_b(THICKNESS) == DripstoneThickness.TIP) {
            entityIn.func_225503_b_(fallDistance * 2.0f, 2.0f);
        } else {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        DripType dripType;
        float nextFloat;
        if (PointedDripstoneBlock.canDrip(stateIn) && (nextFloat = rand.nextFloat()) <= 0.12f && (dripType = PointedDripstoneBlock.getDripType(worldIn, pos, stateIn)) != null && (nextFloat < 0.02f || dripType.canFillCauldron())) {
            PointedDripstoneBlock.spawnDripParticle(worldIn, pos, stateIn, dripType);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.spawnFallingStalactite(state, worldIn, pos);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        this.maybeFillCauldron(state, worldIn, pos, random.nextFloat());
    }

    private void maybeFillCauldron(BlockState state, ServerWorld worldIn, BlockPos pos, float nextFloat) {
        BlockPos tip;
        Fluid fluid;
        if ((nextFloat <= 0.17578125f || nextFloat <= 0.05859375f) && PointedDripstoneBlock.isStalactiteStartPos(state, (IWorldReader)worldIn, pos) && (fluid = PointedDripstoneBlock.getCauldronFillFluidType((World)worldIn, pos)) != Fluids.field_204541_a && (tip = PointedDripstoneBlock.findTip(state, (IWorld)worldIn, pos)) != null) {
            BlockPos cauldronType = null;
            if (fluid == Fluids.field_204546_a && nextFloat < 0.17578125f || fluid == Fluids.field_204547_b && nextFloat < 0.05859375f) {
                cauldronType = PointedDripstoneBlock.findFillableCauldronBelowStalactiteTip((World)worldIn, tip, fluid);
            }
            if (cauldronType != null) {
                PointedDripstoneBlock.spawnDripParticle((World)worldIn, pos, worldIn.func_180495_p(pos));
                int distance = tip.func_177956_o() - cauldronType.func_177956_o();
                int timeBetweenDistance = 50 + distance;
                BlockState cauldronPos = worldIn.func_180495_p(cauldronType);
                worldIn.func_205220_G_().func_205360_a(cauldronType, (Object)cauldronPos.func_177230_c(), timeBetweenDistance);
            }
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction axis;
        BlockPos pos;
        World world = context.func_195991_k();
        Direction direction = PointedDripstoneBlock.calculateTipDirection((IWorldReader)world, pos = context.func_195995_a(), axis = DirectionUtils.getFacingAxis((Entity)context.func_195999_j(), Direction.Axis.Y).func_176734_d());
        if (direction == null) {
            return null;
        }
        boolean flag = !context.func_225518_g_();
        DripstoneThickness thickness = PointedDripstoneBlock.calculateDripstoneThickness((IWorldReader)world, pos, direction, flag);
        return thickness == null ? null : (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)TIP_DIRECTION, (Comparable)direction)).func_206870_a(THICKNESS, (Comparable)((Object)thickness))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        DripstoneThickness thickness = (DripstoneThickness)((Object)state.func_177229_b(THICKNESS));
        VoxelShape shape = thickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (thickness == DripstoneThickness.TIP ? (state.func_177229_b((IProperty)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (thickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (thickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3d vec3d = state.func_191059_e(worldIn, pos);
        return shape.func_197751_a(vec3d.field_72450_a, 0.0, vec3d.field_72449_c);
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    @Override
    public void onBrokenAfterFall(World world, BlockPos pos, FallingBlockEntity fallingBlockEntity) {
        if (!fallingBlockEntity.func_174814_R()) {
            world.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.DRIPSTONE_DRIP_LAND.get(), SoundCategory.BLOCKS, 2.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    private void scheduleStalactiteFallTicks(BlockState state, IWorld worldIn, BlockPos pos) {
        BlockPos blockPos = PointedDripstoneBlock.findTip(state, worldIn, pos);
        if (blockPos != null) {
            BlockPos.Mutable mutable = new BlockPos.Mutable(blockPos);
            while (PointedDripstoneBlock.isStalactite(worldIn.func_180495_p((BlockPos)mutable))) {
                worldIn.func_205220_G_().func_205360_a((BlockPos)mutable, (Object)this, 2);
                mutable.func_189536_c(Direction.UP);
            }
        }
    }

    private void spawnFallingStalactite(BlockState state, ServerWorld worldIn, BlockPos pos) {
        Vec3d vec3d = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        FallingBlockEntity blockEntity = new FallingBlockEntity((World)worldIn, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, state);
        blockEntity.func_145806_a(true);
        blockEntity.field_145813_c = true;
        worldIn.func_217376_c((Entity)blockEntity);
    }

    public static void spawnDripParticle(World worldIn, BlockPos pos, BlockState state) {
        DripType dripType = PointedDripstoneBlock.getDripType(worldIn, pos, state);
        if (dripType != null) {
            PointedDripstoneBlock.spawnDripParticle(worldIn, pos, state, dripType);
        }
    }

    public static void spawnDripParticle(World worldIn, BlockPos pos, BlockState state, DripType dripType) {
        Vec3d vec3d = state.func_191059_e((IBlockReader)worldIn, pos);
        double x = (double)pos.func_177958_n() + 0.5 + vec3d.field_72450_a;
        double y = (double)((float)(pos.func_177956_o() + 1) - 0.6875f) - 0.0625;
        double z = (double)pos.func_177952_p() + 0.5 + vec3d.field_72449_c;
        worldIn.func_195594_a((IParticleData)dripType.getDripParticle(), x, y, z, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState state, IWorld worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)TIP_DIRECTION);
        BlockPos.Mutable mutable = new BlockPos.Mutable(pos);
        BlockState blockState = state;
        for (int i = 0; i < 50; ++i) {
            if (PointedDripstoneBlock.isTip(blockState)) {
                return mutable;
            }
            if (!blockState.func_177230_c().equals(CCBBlocks.POINTED_DRIPSTONE.get()) || blockState.func_177229_b((IProperty)TIP_DIRECTION) != direction) {
                return null;
            }
            mutable.func_189536_c(direction);
            blockState = worldIn.func_180495_p((BlockPos)mutable);
        }
        return null;
    }

    @Nullable
    private static Direction calculateTipDirection(IWorldReader worldIn, BlockPos pos, Direction direction) {
        Direction direction1;
        if (PointedDripstoneBlock.isValidDripstonePlacement(worldIn, pos, direction)) {
            direction1 = direction;
        } else {
            if (!PointedDripstoneBlock.isValidDripstonePlacement(worldIn, pos, direction.func_176734_d())) {
                return null;
            }
            direction1 = direction.func_176734_d();
        }
        return direction1;
    }

    @Nullable
    private static DripstoneThickness calculateDripstoneThickness(IWorldReader worldIn, BlockPos pos, Direction direction, boolean isMerged) {
        Direction oppositeDirection = direction.func_176734_d();
        BlockState blockState = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (PointedDripstoneBlock.isPointedDripstoneWithDirection(blockState, oppositeDirection)) {
            return !isMerged && blockState.func_177229_b(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedDripstoneBlock.isPointedDripstoneWithDirection(blockState, direction)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness thickness = (DripstoneThickness)((Object)blockState.func_177229_b(THICKNESS));
        if (thickness != DripstoneThickness.TIP && thickness != DripstoneThickness.TIP_MERGE) {
            BlockState state = worldIn.func_180495_p(pos.func_177972_a(oppositeDirection));
            if (thickness != DripstoneThickness.FRUSTUM && thickness != DripstoneThickness.MIDDLE) {
                return null;
            }
            return PointedDripstoneBlock.isPointedDripstoneWithDirection(state, direction) ? DripstoneThickness.MIDDLE : DripstoneThickness.BASE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return PointedDripstoneBlock.isStalactite(state) && state.func_177229_b(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false;
    }

    @Nullable
    private static BlockPos findRootBlock(World world, BlockPos pos, BlockState state) {
        Direction direction = ((Direction)state.func_177229_b((IProperty)TIP_DIRECTION)).func_176734_d();
        BlockPos.Mutable mutable = new BlockPos.Mutable(pos);
        for (int i = 0; i < 50; ++i) {
            mutable.func_189536_c(direction);
            BlockState blockState = world.func_180495_p((BlockPos)mutable);
            if (blockState.func_177230_c().equals(CCBBlocks.POINTED_DRIPSTONE.get())) continue;
            return mutable;
        }
        return null;
    }

    private static boolean isValidDripstonePlacement(IWorldReader worldIn, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        BlockState state = worldIn.func_180495_p(blockPos);
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction.func_176734_d()), (Direction)direction) || PointedDripstoneBlock.isPointedDripstoneWithDirection(state, direction);
    }

    private static boolean isTip(BlockState state) {
        if (!state.func_177230_c().equals(CCBBlocks.POINTED_DRIPSTONE.get())) {
            return false;
        }
        DripstoneThickness thickness = (DripstoneThickness)((Object)state.func_177229_b(THICKNESS));
        return thickness == DripstoneThickness.TIP || thickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isStalactite(BlockState state) {
        return PointedDripstoneBlock.isPointedDripstoneWithDirection(state, Direction.DOWN);
    }

    private static boolean isStalactiteStartPos(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return PointedDripstoneBlock.isStalactite(state) && !worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().equals(CCBBlocks.POINTED_DRIPSTONE.get());
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction direction) {
        return state.func_177230_c().equals(CCBBlocks.POINTED_DRIPSTONE.get()) && state.func_177229_b((IProperty)TIP_DIRECTION) == direction;
    }

    @Nullable
    private static BlockPos findFillableCauldronBelowStalactiteTip(World worldIn, BlockPos pos, Fluid fluid) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(pos);
        for (int i = 0; i < 10; ++i) {
            AbstractCauldronBlock cauldronBlock;
            mutable.func_189536_c(Direction.DOWN);
            BlockState state = worldIn.func_180495_p((BlockPos)mutable);
            if (state.func_196958_f()) continue;
            if (state.func_177230_c() instanceof AbstractCauldronBlock && (cauldronBlock = (AbstractCauldronBlock)state.func_177230_c()).canReceiveStalactiteDrip(fluid)) {
                return mutable;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static BlockPos findStalactiteTipAboveCauldron(World worldIn, BlockPos pos) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(pos);
        for (int i = 0; i < 10; ++i) {
            mutable.func_189536_c(Direction.UP);
            BlockState state = worldIn.func_180495_p((BlockPos)mutable);
            if (state.func_196958_f()) continue;
            if (PointedDripstoneBlock.canDrip(state)) {
                return mutable;
            }
            return null;
        }
        return null;
    }

    public static Fluid getCauldronFillFluidType(World worldIn, BlockPos pos) {
        DripType dripType = PointedDripstoneBlock.getDripType(worldIn, pos, worldIn.func_180495_p(pos));
        return dripType != null && dripType.canFillCauldron() ? dripType.getDripFluid() : Fluids.field_204541_a;
    }

    @Nullable
    private static DripType getDripType(World worldIn, BlockPos pos, BlockState state) {
        if (!PointedDripstoneBlock.isStalactite(state)) {
            return null;
        }
        BlockPos blockPos = PointedDripstoneBlock.findRootBlock(worldIn, pos, state);
        if (blockPos == null) {
            return null;
        }
        IFluidState fluidState = worldIn.func_204610_c(blockPos.func_177984_a());
        return new DripType(fluidState.func_206886_c());
    }

    public SoundType func_220072_p(BlockState state) {
        return CCBSoundType.DRIPSTONE;
    }

    static class DripType {
        private final Fluid fluidAboveRootBlock;

        DripType(Fluid fluid) {
            this.fluidAboveRootBlock = fluid;
        }

        Fluid getDripFluid() {
            return this.fluidAboveRootBlock.func_207185_a(FluidTags.field_206960_b) ? Fluids.field_204547_b : Fluids.field_204546_a;
        }

        boolean canFillCauldron() {
            return this.fluidAboveRootBlock == Fluids.field_204547_b || this.fluidAboveRootBlock == Fluids.field_204546_a;
        }

        BasicParticleType getDripParticle() {
            return this.getDripFluid() == Fluids.field_204546_a ? ParticleTypes.field_197618_k : ParticleTypes.field_197617_j;
        }
    }
}

