/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.block;

import com.blackgear.cavesandcliffs.common.block.util.BucketPickup;
import com.blackgear.cavesandcliffs.common.tags.CCBEntityTags;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBItems;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class PowderSnowBlock
extends Block
implements BucketPickup {
    public PowderSnowBlock(Block.Properties properties) {
        super(properties);
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_177230_c().equals(this) ? true : super.func_200122_a(state, adjacentBlockState, side);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!(entityIn instanceof LivingEntity) || entityIn.field_70170_p.func_180495_p(entityIn.func_226268_ag_()).func_177230_c().equals(CCBBlocks.POWDER_SNOW.get())) {
            entityIn.func_213295_a(state, new Vec3d((double)0.9f, (double)0.99f, (double)0.9f));
        }
        if (worldIn.field_72995_K) {
            entityIn.func_70066_B();
        }
        if (!entityIn.func_175149_v() && (entityIn.field_70169_q != entityIn.func_226277_ct_() || entityIn.field_70166_s != entityIn.func_226281_cx_()) && worldIn.field_73012_v.nextBoolean()) {
            this.spawnPowderSnowParticles(worldIn, new Vec3d(entityIn.func_226277_ct_(), (double)pos.func_177956_o(), entityIn.func_226281_cx_()));
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (context instanceof EntitySelectionContext) {
            boolean isFallingBlock;
            EntitySelectionContext collision = (EntitySelectionContext)context;
            Optional<Entity> entity = Optional.ofNullable(collision.getEntity());
            boolean bl = isFallingBlock = entity.isPresent() && entity.get() instanceof FallingBlockEntity;
            if (isFallingBlock || entity.isPresent() && this.canEntityWalkOnPowderSnow(entity.get()) && context.func_216378_a(VoxelShapes.func_197868_b(), pos, false) && !context.func_225581_b_()) {
                return super.func_220071_b(state, worldIn, pos, context);
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    private void spawnPowderSnowParticles(World worldIn, Vec3d vec3d) {
        if (worldIn.field_72995_K) {
            Random rand = worldIn.func_201674_k();
            double getY = vec3d.field_72448_b + 1.0;
            for (int i = 0; i < rand.nextInt(3); ++i) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197613_f, vec3d.field_72450_a, getY, vec3d.field_72449_c, (double)((-1.0f + rand.nextFloat() * 2.0f) / 12.0f), (double)0.05f, (double)((-1.0f + rand.nextFloat() * 2.0f) / 12.0f));
            }
        }
    }

    private boolean canEntityWalkOnPowderSnow(Entity entityIn) {
        if (entityIn.func_200600_R().func_220341_a(CCBEntityTags.POWDER_SNOW_WALKABLE_MOBS)) {
            return true;
        }
        return entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_184582_a(EquipmentSlotType.FEET).func_77973_b().equals(Items.field_151021_T);
    }

    @Override
    public ItemStack pickupBlock(IWorld worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
        if (!worldIn.func_201670_d()) {
            worldIn.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
        }
        return new ItemStack((IItemProvider)CCBItems.POWDER_SNOW_BUCKET.get());
    }

    @Override
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.field_187630_M);
    }
}

