/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.block.util;

import com.blackgear.cavesandcliffs.common.block.sound.CCBSoundEvents;
import com.blackgear.cavesandcliffs.common.block.sound.CCBSoundType;
import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class AbstractCandleBlock
extends Block {
    public static BooleanProperty LIT = BlockStateProperties.field_208190_q;

    public AbstractCandleBlock(Block.Properties properties) {
        super(properties);
    }

    protected abstract Iterable<Vec3d> getParticleOffsets(BlockState var1);

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, Entity projectile) {
        if (worldIn.field_72995_K && projectile.func_70027_ad() && !((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            AbstractCandleBlock.setLitState((IWorld)worldIn, state, hit.func_216350_a(), true);
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            this.getParticleOffsets(stateIn).forEach(vec3d -> AbstractCandleBlock.addParticlesAndSounds(worldIn, vec3d.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), rand));
        }
    }

    private static void addParticlesAndSounds(World worldIn, Vec3d motion, Random random) {
        float rand = random.nextFloat();
        if (rand < 0.3f) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c, 0.0, 0.0, 0.0);
            if (rand < 0.17f) {
                worldIn.func_184134_a(motion.field_72450_a + 0.5, motion.field_72448_b + 0.5, motion.field_72449_c + 0.5, (SoundEvent)CCBSoundEvents.BLOCK_CANDLE_AMBIENT.get(), SoundCategory.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        worldIn.func_195594_a((IParticleData)CCBParticleTypes.SMALL_FLAME.get(), motion.field_72450_a, motion.field_72448_b, motion.field_72449_c, 0.0, 0.0, 0.0);
    }

    protected static void extinguish(BlockState state, IWorld worldIn, BlockPos pos) {
        AbstractCandleBlock.setLitState(worldIn, state, pos, false);
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177956_o(), 0.0, (double)0.1f, 0.0);
        worldIn.func_184133_a((PlayerEntity)null, pos, (SoundEvent)CCBSoundEvents.BLOCK_CANDLE_EXTINGUISH.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private static void setLitState(IWorld worldIn, BlockState state, BlockPos pos, boolean litValue) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(litValue)), 11);
    }

    public SoundType func_220072_p(BlockState state) {
        return CCBSoundType.CANDLE;
    }
}

