/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.block.util;

import com.blackgear.cavesandcliffs.common.block.util.AbstractTopPlantBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractPlantBlock
extends Block {
    protected final Direction growthDirection;
    protected final boolean scheduleFluidTicks;
    protected final VoxelShape shape;

    public AbstractPlantBlock(Block.Properties properties, Direction growthDirection, VoxelShape shape, boolean scheduleFluidTicks) {
        super(properties);
        this.growthDirection = growthDirection;
        this.shape = shape;
        this.scheduleFluidTicks = scheduleFluidTicks;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(this.growthDirection));
        return !blockstate.func_177230_c().equals((Object)this.getTopPlantBlock()) && !blockstate.func_177230_c().equals(this.getBodyPlantBlock()) ? this.getStateForPlacement((IWorld)context.func_195991_k()) : this.getBodyPlantBlock().func_176223_P();
    }

    public BlockState getStateForPlacement(IWorld world) {
        return this.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177972_a(this.growthDirection.func_176734_d());
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (!this.canGrowOn(block)) {
            return false;
        }
        return block == this.getTopPlantBlock() || block == this.getBodyPlantBlock() || blockstate.func_224755_d((IBlockReader)worldIn, blockpos, this.growthDirection);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    protected boolean canGrowOn(Block block) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shape;
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    protected abstract AbstractTopPlantBlock getTopPlantBlock();

    protected abstract Block getBodyPlantBlock();
}

