/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.block.util;

import com.blackgear.cavesandcliffs.common.block.util.AbstractPlantBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractTopPlantBlock
extends AbstractPlantBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208172_Y;
    private final double growthChance;

    public AbstractTopPlantBlock(Block.Properties properties, Direction growthDirection, VoxelShape shape, boolean scheduleFluidTicks, double growthChance) {
        super(properties, growthDirection, shape, scheduleFluidTicks);
        this.growthChance = growthChance;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockState getStateForPlacement(IWorld world) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(world.func_201674_k().nextInt(25)));
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 25;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        BlockPos blockpos;
        if ((Integer)state.func_177229_b((IProperty)AGE) < 25 && random.nextDouble() < this.growthChance && this.canGrowIn(worldIn.func_180495_p(blockpos = pos.func_177972_a(this.growthDirection)))) {
            worldIn.func_175656_a(blockpos, this.getGrowIntoState(state, worldIn.field_73012_v));
        }
    }

    protected BlockState getGrowIntoState(BlockState state, Random rand) {
        return (BlockState)state.func_177231_a((IProperty)AGE);
    }

    protected BlockState updateBodyAfterConvertedFromHead(BlockState head, BlockState body) {
        return body;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == this.growthDirection.func_176734_d() && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        if (facing != this.growthDirection || !facingState.func_177230_c().equals((Object)this) && !facingState.func_177230_c().equals(this.getBodyPlantBlock())) {
            if (this.scheduleFluidTicks) {
                worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            }
            return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return this.updateBodyAfterConvertedFromHead(stateIn, this.getBodyPlantBlock().func_176223_P());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return this.canGrowIn(worldIn.func_180495_p(pos.func_177972_a(this.growthDirection)));
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.func_177972_a(this.growthDirection);
        int i = Math.min((Integer)state.func_177229_b((IProperty)AGE) + 1, 25);
        int j = this.getGrowthAmount(rand);
        for (int k = 0; k < j && this.canGrowIn(worldIn.func_180495_p(blockpos)); ++k) {
            worldIn.func_175656_a(blockpos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i)));
            blockpos = blockpos.func_177972_a(this.growthDirection);
            i = Math.min(i + 1, 25);
        }
    }

    protected abstract int getGrowthAmount(Random var1);

    protected abstract boolean canGrowIn(BlockState var1);

    @Override
    protected AbstractTopPlantBlock getTopPlantBlock() {
        return this;
    }
}

