/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity.ai.sensor;

import com.blackgear.cavesandcliffs.common.util.entity.EntityHelper;
import com.blackgear.cavesandcliffs.core.registries.CCBMemoryModuleType;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EntityPredicates;
import net.minecraft.world.server.ServerWorld;

public class TemptingSensor
extends Sensor<LivingEntity> {
    private static final EntityPredicate TEMPT_TARGETING = new EntityPredicate().func_221013_a(10.0).func_221008_a().func_221011_b().func_221014_c().func_221010_e();
    private final Ingredient temptations;

    public TemptingSensor(Ingredient temptations) {
        this.temptations = temptations;
    }

    protected void func_212872_a_(ServerWorld worldIn, LivingEntity entityIn) {
        Brain brain = entityIn.func_213375_cj();
        List playersInRadius = worldIn.func_217369_A().stream().filter(EntityPredicates.field_180132_d).filter(targetIn -> TEMPT_TARGETING.func_221015_a(entityIn, (LivingEntity)targetIn)).filter(targetIn -> EntityHelper.withinDistance((Entity)entityIn, (Entity)targetIn, 10.0)).filter(this::playerHoldingTemptation).sorted(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entityIn).func_70068_e(arg_0))).collect(Collectors.toList());
        if (!playersInRadius.isEmpty()) {
            PlayerEntity playerEntity = (PlayerEntity)playersInRadius.get(0);
            brain.func_218205_a(CCBMemoryModuleType.TEMPTING_PLAYER, (Object)playerEntity);
        } else {
            brain.func_218189_b(CCBMemoryModuleType.TEMPTING_PLAYER);
        }
    }

    private boolean playerHoldingTemptation(PlayerEntity playerEntity) {
        return this.isTemptation(playerEntity.func_184614_ca()) || this.isTemptation(playerEntity.func_184592_cb());
    }

    private boolean isTemptation(ItemStack stack) {
        return this.temptations.test(stack);
    }

    public Set<MemoryModuleType<?>> func_220974_a() {
        return ImmutableSet.of(CCBMemoryModuleType.TEMPTING_PLAYER);
    }
}

