/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity.passive;

import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GlowSquidEntity
extends SquidEntity {
    private static final DataParameter<Integer> DATA_DARK_TICKS_REMAINING = EntityDataManager.func_187226_a(GlowSquidEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public GlowSquidEntity(EntityType<? extends SquidEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected IParticleData getInkParticle() {
        return (IParticleData)CCBParticleTypes.GLOW_SQUID_INK.get();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_DARK_TICKS_REMAINING, (Object)0);
    }

    public static boolean canGlowSquidSpawnOn(EntityType<GlowSquidEntity> entityIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random p_223365_4_) {
        return pos.func_177956_o() < 45;
    }

    protected SoundEvent getSquirtSound() {
        return SoundEvents.field_203639_hT;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("DarkTicksRemaining", this.getDarkTicksRemaining());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setDarkTicks(compound.func_74762_e("DarkTicksRemaining"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        int remainingDarkTicks = this.getDarkTicksRemaining();
        if (remainingDarkTicks > 0) {
            this.setDarkTicks(remainingDarkTicks - 1);
        }
        this.field_70170_p.func_195594_a((IParticleData)CCBParticleTypes.GLOW.get(), this.func_226282_d_(0.6), this.func_226279_cv_(), this.func_226287_g_(0.6), 0.0, 0.0, 0.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean wasHurt = super.func_70097_a(source, amount);
        if (wasHurt) {
            this.setDarkTicks(100);
        }
        return false;
    }

    private Vec3d rotateVector(Vec3d vector) {
        Vec3d vec3d = vector.func_178789_a(this.field_70862_e * ((float)Math.PI / 180));
        vec3d = vec3d.func_178785_b(-this.field_70760_ar * ((float)Math.PI / 180));
        return vec3d;
    }

    public void func_203039_dq() {
        this.func_184185_a(this.getSquirtSound(), this.func_70599_aP(), this.func_70647_i());
        Vec3d vec3d = this.rotateVector(new Vec3d(0.0, -1.0, 0.0)).func_72441_c(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        for (int i = 0; i < 30; ++i) {
            Vec3d vec3d1 = this.rotateVector(new Vec3d((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3, -1.0, (double)this.field_70146_Z.nextFloat() * 0.6 - 0.3));
            Vec3d vec3d2 = vec3d1.func_186678_a(0.3 + (double)(this.field_70146_Z.nextFloat() * 2.0f));
            ((ServerWorld)this.field_70170_p).func_195598_a(this.getInkParticle(), vec3d.field_72450_a, vec3d.field_72448_b + 0.5, vec3d.field_72449_c, 0, vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c, (double)0.1f);
        }
    }

    private void setDarkTicks(int ticks) {
        this.field_70180_af.func_187227_b(DATA_DARK_TICKS_REMAINING, (Object)ticks);
    }

    public int getDarkTicksRemaining() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_DARK_TICKS_REMAINING);
    }
}

