/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity.passive.axolotl;

import com.blackgear.cavesandcliffs.common.entity.passive.axolotl.AxolotlTasks;
import com.blackgear.cavesandcliffs.common.entity.passive.axolotl.SmoothSwimmingLookController;
import com.blackgear.cavesandcliffs.common.entity.passive.axolotl.SmoothSwimmingMovementController;
import com.blackgear.cavesandcliffs.common.item.util.ItemUtils;
import com.blackgear.cavesandcliffs.common.tags.CCBItemTags;
import com.blackgear.cavesandcliffs.common.util.IntSerializable;
import com.blackgear.cavesandcliffs.common.util.entity.BrainHelper;
import com.blackgear.cavesandcliffs.common.util.entity.EntityHelper;
import com.blackgear.cavesandcliffs.common.util.world.WorldHelper;
import com.blackgear.cavesandcliffs.core.CCBUtils;
import com.blackgear.cavesandcliffs.core.registries.CCBEntityType;
import com.blackgear.cavesandcliffs.core.registries.CCBMemoryModuleType;
import com.blackgear.cavesandcliffs.core.registries.CCBSensorType;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.pathfinding.WalkAndSwimNodeProcessor;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AxolotlEntity
extends AnimalEntity {
    public static final Predicate<LivingEntity> NOT_PLAYING_DEAD_SELECTOR = entityIn -> entityIn.func_200600_R() == CCBEntityType.AXOLOTL.get() && !((AxolotlEntity)((Object)entityIn)).isPlayingDead();
    protected static final ImmutableList<SensorType<? extends Sensor<? super AxolotlEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)CCBSensorType.NEAREST_ADULT.get(), (Object)SensorType.field_221002_f, (Object)CCBSensorType.AXOLOTL_HOSTILES.get(), (Object)CCBSensorType.AXOLOTL_TEMPTATIONS.get());
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(CCBMemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.field_220945_f, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220949_j, CCBMemoryModuleType.NEAREST_VISIBLE_TARGETABLE_PLAYER, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleType.field_220954_o, CCBMemoryModuleType.ATTACK_TARGET, CCBMemoryModuleType.ATTACK_COOLING_DOWN, CCBMemoryModuleType.NEAREST_VISIBLE_ADULT, (Object[])new MemoryModuleType[]{MemoryModuleType.field_220958_s, CCBMemoryModuleType.PLAY_DEAD_TICKS, MemoryModuleType.field_220959_t, CCBMemoryModuleType.TEMPTING_PLAYER, CCBMemoryModuleType.TEMPTATION_COOLDOWN_TICKS, CCBMemoryModuleType.IS_TEMPTED});
    private static final DataParameter<Integer> DATA_VARIANT = EntityDataManager.func_187226_a(AxolotlEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATA_PLAYING_DEAD = EntityDataManager.func_187226_a(AxolotlEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(AxolotlEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public AxolotlEntity(EntityType<? extends AxolotlEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new AxolotlMovementController(this);
        this.field_70749_g = new AxolotlLookController((MobEntity)this, 20);
        this.field_70138_W = 1.0f;
        this.field_213378_br = this.func_213364_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)new CompoundNBT()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(DATA_PLAYING_DEAD, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant().getId());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(Variant.BY_ID[compound.func_74762_e("Variant")]);
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        boolean isInGroup = false;
        if (spawnDataIn instanceof AxolotlGroupData) {
            if (((AxolotlGroupData)((Object)spawnDataIn)).func_226257_a_() >= 2) {
                isInGroup = true;
            }
        } else {
            spawnDataIn = new AxolotlGroupData(Variant.getCommonSpawnVariant(this.field_70170_p.field_73012_v), Variant.getCommonSpawnVariant(this.field_70170_p.field_73012_v));
        }
        this.setVariant(((AxolotlGroupData)((Object)spawnDataIn)).getVariant(this.field_70170_p.field_73012_v));
        if (isInGroup) {
            this.func_70873_a(-24000);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70030_z() {
        int air = this.func_70086_ai();
        super.func_70030_z();
        if (!this.func_175446_cd()) {
            this.handleAirSupply(air);
        }
    }

    protected void handleAirSupply(int air) {
        if (this.func_70089_S() && !this.func_203008_ap()) {
            this.func_70050_g(air - 1);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70665_d(DamageSource.field_205132_u, 2.0f);
            }
        } else {
            this.func_70050_g(this.func_205010_bg());
        }
    }

    public int func_205010_bg() {
        return 6000;
    }

    public Variant getVariant() {
        return Variant.BY_ID[(Integer)this.field_70180_af.func_187225_a(DATA_VARIANT)];
    }

    private void setVariant(Variant variant) {
        this.field_70180_af.func_187227_b(DATA_VARIANT, (Object)variant.getId());
    }

    private static boolean useRareVariant(Random rand) {
        return rand.nextInt(1200) == 0;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public void setPlayingDead(boolean isPlayingDead) {
        this.field_70180_af.func_187227_b(DATA_PLAYING_DEAD, (Object)isPlayingDead);
    }

    public boolean isPlayingDead() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_PLAYING_DEAD);
    }

    public double func_213340_A(@Nullable Entity lookingEntity) {
        return this.isPlayingDead() ? 0.0 : 1.0;
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity entityIn) {
        AxolotlEntity axolotl = (AxolotlEntity)((EntityType)CCBEntityType.AXOLOTL.get()).func_200721_a(this.field_70170_p);
        if (axolotl != null) {
            Variant variant = AxolotlEntity.useRareVariant(this.field_70146_Z) ? Variant.getRareSpawnVariant(this.field_70146_Z) : (this.field_70146_Z.nextBoolean() ? this.getVariant() : ((AxolotlEntity)entityIn).getVariant());
            axolotl.setVariant(variant);
        }
        return axolotl;
    }

    public boolean isFood(ItemStack stack) {
        return CCBItemTags.AXOLOTL_TEMPT_ITEMS.func_199685_a_((Object)stack.func_77973_b());
    }

    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("axolotlBrain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("axolotlActivityUpdate");
        AxolotlTasks.updateActivity(this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (!this.func_175446_cd()) {
            Optional playingDeadTicks = this.func_213375_cj().func_218207_c(CCBMemoryModuleType.PLAY_DEAD_TICKS);
            this.setPlayingDead(playingDeadTicks.isPresent() && ((IntSerializable)playingDeadTicks.get()).getValue() > 0);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new AxolotlPathNavigation((MobEntity)this, worldIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean canAttack = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (canAttack) {
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_184185_a(SoundEvents.field_219632_dv, 1.0f, 1.0f);
        }
        return super.func_70652_k(entityIn);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        float health = this.func_110143_aJ();
        if (!this.field_70170_p.field_72995_K && !this.func_175446_cd() && this.field_70170_p.field_73012_v.nextInt(3) == 0 && ((float)this.field_70170_p.field_73012_v.nextInt(3) < damageAmount || health / this.func_110138_aP() < 0.5f) && damageAmount < health && damageSrc != DamageSource.field_205132_u && !this.isPlayingDead()) {
            BrainHelper.setMemory(this.field_213378_br, CCBMemoryModuleType.PLAY_DEAD_TICKS, IntSerializable.of(200));
        }
        super.func_70665_d(damageSrc, damageAmount);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.275f;
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        return ItemUtils.bucketMobPickup(player, hand, (LivingEntity)this, SoundEvents.field_187630_M, () -> new ItemStack((IItemProvider)Items.field_204272_aO)).orElse(super.func_184645_a(player, hand));
    }

    public boolean canBeTargeted() {
        return !this.isPlayingDead();
    }

    public void func_70624_b(@Nullable LivingEntity entityIn) {
        Entity targetEntity;
        DamageSource damageSource;
        LivingEntity target;
        if (entityIn == null && (target = this.func_70638_az()) != null && target.func_110143_aJ() <= 0.0f && (damageSource = target.func_189748_bU()) != null && (targetEntity = target.getEntity()) != null && targetEntity.func_200600_R() == EntityType.field_200729_aH) {
            PlayerEntity playerTarget = (PlayerEntity)targetEntity;
            List playersInRadius = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(20.0));
            if (playersInRadius.contains(playerTarget)) {
                this.applyRegenEffect(playerTarget);
            }
        }
        super.func_70624_b(entityIn);
    }

    public void applyRegenEffect(PlayerEntity player) {
        EffectInstance effect = player.func_70660_b(Effects.field_76428_l);
        int duration = 100 + (effect != null ? effect.func_76459_b() : 0);
        player.func_195064_c(new EffectInstance(Effects.field_76428_l, duration, 0));
        player.func_195063_d(Effects.field_76419_f);
    }

    public boolean func_213392_I() {
        return super.func_213392_I();
    }

    public static boolean checkAxolotlSpawnRules(EntityType<?> entityType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        return worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a) && !WorldHelper.canSeeSkyFromBelowWater(worldIn, pos);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return super.func_184601_bQ(damageSourceIn);
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return super.func_184615_bR();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    protected SoundEvent func_184181_aa() {
        return super.func_184181_aa();
    }

    protected SoundEvent func_184184_Z() {
        return super.func_184184_Z();
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        Brain brain = new Brain(MEMORY_TYPES, SENSOR_TYPES, dynamicIn);
        AxolotlTasks.makeBrain((Brain<AxolotlEntity>)brain);
        return brain;
    }

    public Brain<AxolotlEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_218798_a((LivingEntity)this);
    }

    public void func_213352_e(Vec3d motion) {
        if (EntityHelper.isEffectiveAi((MobEntity)this) && this.func_70090_H()) {
            this.func_213309_a(this.func_225515_ai_(), motion);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(motion);
        }
    }

    protected void func_175505_a(PlayerEntity player, ItemStack stack) {
        Hand hand = player.func_184600_cs();
        if (stack.func_77973_b().equals(Items.field_204272_aO)) {
            player.func_184611_a(hand, !player.field_71075_bZ.field_75098_d ? new ItemStack((IItemProvider)Items.field_151133_ar) : stack);
        } else {
            super.func_175505_a(player, stack);
        }
    }

    public static enum Variant {
        LUCY(0, "lucy", true),
        WILD(1, "wild", true),
        GOLD(2, "gold", true),
        CYAN(3, "cyan", true),
        BLUE(4, "blue", false);

        public static final Variant[] BY_ID;
        private final int id;
        private final String name;
        private final boolean common;

        private Variant(int id, String name, boolean isCommon) {
            this.id = id;
            this.name = name;
            this.common = isCommon;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Variant getCommonSpawnVariant(Random rand) {
            return Variant.getSpawnVariant(rand, true);
        }

        public static Variant getRareSpawnVariant(Random rand) {
            return Variant.getSpawnVariant(rand, false);
        }

        public static Variant getSpawnVariant(Random rand, boolean isCommon) {
            Variant[] variants = (Variant[])Arrays.stream(BY_ID).filter(variant -> variant.common == isCommon).toArray(Variant[]::new);
            return (Variant)((Object)CCBUtils.getRandom((Object[])variants, rand));
        }

        static {
            BY_ID = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparing(Variant::getId)).toArray(Variant[]::new);
        }
    }

    static class AxolotlMovementController
    extends SmoothSwimmingMovementController {
        private final AxolotlEntity axolotlEntity;

        public AxolotlMovementController(AxolotlEntity axolotl) {
            super((MobEntity)axolotl, 85, 10, 0.1f, 0.5f, false);
            this.axolotlEntity = axolotl;
        }

        @Override
        public void func_75641_c() {
            if (!this.axolotlEntity.isPlayingDead()) {
                super.func_75641_c();
            }
        }
    }

    class AxolotlLookController
    extends SmoothSwimmingLookController {
        public AxolotlLookController(MobEntity mob, int maxYRotFromCenter) {
            super(mob, maxYRotFromCenter);
        }

        @Override
        public void func_75649_a() {
            if (!AxolotlEntity.this.isPlayingDead()) {
                super.func_75649_a();
            }
        }
    }

    public static class AxolotlGroupData
    extends AgeableEntity.AgeableData {
        public final Variant[] types;

        public AxolotlGroupData(Variant ... variants) {
            this.types = variants;
        }

        public Variant getVariant(Random rand) {
            return AxolotlEntity.useRareVariant(rand) ? Variant.getRareSpawnVariant(rand) : this.types[rand.nextInt(this.types.length)];
        }
    }

    static class AxolotlPathNavigation
    extends SwimmerPathNavigator {
        public AxolotlPathNavigation(MobEntity entityLivingIn, World worldIn) {
            super(entityLivingIn, worldIn);
        }

        public boolean func_188553_i() {
            return true;
        }

        protected PathFinder func_179679_a(int id) {
            this.field_179695_a = new WalkAndSwimNodeProcessor();
            return new PathFinder(this.field_179695_a, id);
        }

        public boolean func_188555_b(BlockPos pos) {
            BlockPos below = pos.func_177977_b();
            return this.field_75513_b.func_180495_p(below).func_224756_o((IBlockReader)this.field_75513_b, below);
        }
    }
}

