/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity.passive.axolotl;

import com.blackgear.cavesandcliffs.common.entity.passive.axolotl.AxolotlEntity;
import com.blackgear.cavesandcliffs.common.entity.passive.axolotl.CountDownTemptationTicksTask;
import com.blackgear.cavesandcliffs.common.entity.passive.axolotl.ValidatePlayDeathTask;
import com.blackgear.cavesandcliffs.common.entity.passive.axolotl.WalkToTargetTask;
import com.blackgear.cavesandcliffs.common.tags.CCBItemTags;
import com.blackgear.cavesandcliffs.common.util.entity.BrainHelper;
import com.blackgear.cavesandcliffs.common.util.math.IntRange;
import com.blackgear.cavesandcliffs.core.registries.CCBActivity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.item.crafting.Ingredient;

public class AxolotlTasks {
    private static final IntRange ADULT_FOLLOW_RANGE = IntRange.of(5, 16);

    protected static Brain makeBrain(Brain<AxolotlEntity> brain) {
        AxolotlTasks.initCoreActivity(brain);
        AxolotlTasks.initIdleActivity(brain);
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_218202_a(Activity.field_221366_b);
        BrainHelper.switchToFallbackActivity(brain);
        return brain;
    }

    private static void initCoreActivity(Brain<AxolotlEntity> brain) {
        BrainHelper.registerActivity(brain, Activity.field_221365_a, 0, ImmutableList.of((Object)new LookTask(45, 90), (Object)((Object)new WalkToTargetTask()), (Object)((Object)new ValidatePlayDeathTask()), (Object)((Object)new CountDownTemptationTicksTask())));
    }

    private static void initIdleActivity(Brain<AxolotlEntity> brain) {
        brain.func_218208_a(Activity.field_221366_b, ImmutableList.of());
    }

    public static void updateActivity(AxolotlEntity axolotlEntity) {
        Brain<AxolotlEntity> brain = axolotlEntity.func_213375_cj();
        Activity activity = BrainHelper.getActiveNonCoreActivity(brain).orElse(null);
        if (activity != CCBActivity.PLAY_DEAD.get()) {
            BrainHelper.switchActivities(brain, (List<Activity>)ImmutableList.of((Object)CCBActivity.PLAY_DEAD.get(), (Object)CCBActivity.FIGHT.get(), (Object)Activity.field_221366_b));
        }
    }

    private static float getSpeedModifierChasing(LivingEntity entityIn) {
        return entityIn.func_203005_aq() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifierFollowingAdult(LivingEntity entityIn) {
        return entityIn.func_203005_aq() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifier(LivingEntity entityIn) {
        return entityIn.func_203005_aq() ? 0.5f : 0.15f;
    }

    private static Optional<LivingEntity> findNeatestValidAttackTarget(AxolotlEntity axolotlEntity) {
        return AxolotlTasks.isBreeding(axolotlEntity) ? Optional.empty() : axolotlEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220959_t);
    }

    private static boolean isBreeding(AxolotlEntity axolotlEntity) {
        return axolotlEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_220953_n);
    }

    public static Ingredient getTemptations() {
        return Ingredient.func_199805_a(CCBItemTags.AXOLOTL_TEMPT_ITEMS);
    }
}

