/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity.passive.axolotl;

import com.blackgear.cavesandcliffs.common.util.math.Vec3dHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.server.ServerWorld;

public class WalkToTargetTask
extends Task<MobEntity> {
    private int remainingCooldown;
    @Nullable
    private Path path;
    @Nullable
    private BlockPos lastTargetPos;
    private float speedModifier;

    public WalkToTargetTask() {
        this(150, 250);
    }

    public WalkToTargetTask(int distance, int speedModifier) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_220954_o, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_PRESENT), distance, speedModifier);
    }

    protected boolean shouldExecute(ServerWorld worldIn, MobEntity owner) {
        if (this.remainingCooldown > 0) {
            --this.remainingCooldown;
            return false;
        }
        Brain brain = owner.func_213375_cj();
        WalkTarget walkTarget = (WalkTarget)brain.func_218207_c(MemoryModuleType.field_220950_k).get();
        boolean hasReachedTarget = this.reachedTarget(owner, walkTarget);
        if (!hasReachedTarget && this.tryComputePath(owner, walkTarget, worldIn.func_82737_E())) {
            this.lastTargetPos = walkTarget.func_220966_a().func_220608_a();
            return true;
        }
        brain.func_218189_b(MemoryModuleType.field_220950_k);
        if (hasReachedTarget) {
            brain.func_218189_b(MemoryModuleType.field_223021_x);
        }
        return false;
    }

    protected boolean shouldContinueExecuting(ServerWorld worldIn, MobEntity entityIn, long gameTimeIn) {
        if (this.path != null && this.lastTargetPos != null) {
            Optional walkTarget = entityIn.func_213375_cj().func_218207_c(MemoryModuleType.field_220950_k);
            PathNavigator pathNavigator = entityIn.func_70661_as();
            return !pathNavigator.func_75500_f() && walkTarget.isPresent() && !this.reachedTarget(entityIn, (WalkTarget)walkTarget.get());
        }
        return false;
    }

    protected void resetTask(ServerWorld worldIn, MobEntity entityIn, long gameTimeIn) {
        if (entityIn.func_213375_cj().func_218191_a(MemoryModuleType.field_220950_k) && !this.reachedTarget(entityIn, (WalkTarget)entityIn.func_213375_cj().func_218207_c(MemoryModuleType.field_220950_k).get()) && entityIn.func_70661_as().func_75500_f()) {
            this.remainingCooldown = worldIn.func_201674_k().nextInt(40);
        }
        entityIn.func_70661_as().func_75499_g();
        entityIn.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        entityIn.func_213375_cj().func_218189_b(MemoryModuleType.field_220954_o);
        this.path = null;
    }

    protected void startExecuting(ServerWorld worldIn, MobEntity entityIn, long gameTimeIn) {
        entityIn.func_213375_cj().func_218205_a(MemoryModuleType.field_220954_o, (Object)this.path);
        entityIn.func_70661_as().func_75484_a(this.path, (double)this.speedModifier);
    }

    protected void updateTask(ServerWorld worldIn, MobEntity owner, long gameTime) {
        WalkTarget walkTarget;
        Path path = owner.func_70661_as().func_75505_d();
        Brain brain = owner.func_213375_cj();
        if (this.path != path) {
            this.path = path;
            brain.func_218205_a(MemoryModuleType.field_220954_o, (Object)path);
        }
        if (path != null && this.lastTargetPos != null && (walkTarget = (WalkTarget)brain.func_218207_c(MemoryModuleType.field_220950_k).get()).func_220966_a().func_220608_a().func_177951_i((Vec3i)this.lastTargetPos) > 4.0 && this.tryComputePath(owner, walkTarget, worldIn.func_82737_E())) {
            this.lastTargetPos = walkTarget.func_220966_a().func_220608_a();
            this.startExecuting(worldIn, owner, gameTime);
        }
    }

    private boolean tryComputePath(MobEntity entityIn, WalkTarget targetIn, long maxDistance) {
        BlockPos blockPos = targetIn.func_220966_a().func_220608_a();
        this.path = entityIn.func_70661_as().func_179680_a(blockPos, 0);
        this.speedModifier = targetIn.func_220965_b();
        Brain brain = entityIn.func_213375_cj();
        if (this.reachedTarget(entityIn, targetIn)) {
            brain.func_218189_b(MemoryModuleType.field_223021_x);
        } else {
            boolean hasReachedTarget;
            boolean bl = hasReachedTarget = this.path != null && this.path.func_224771_h();
            if (hasReachedTarget) {
                brain.func_218189_b(MemoryModuleType.field_223021_x);
            } else if (!brain.func_218191_a(MemoryModuleType.field_223021_x)) {
                brain.func_218205_a(MemoryModuleType.field_223021_x, (Object)maxDistance);
            }
            if (this.path != null) {
                return true;
            }
            Vec3d vec3d = RandomPositionGenerator.func_75464_a((CreatureEntity)((CreatureEntity)entityIn), (int)10, (int)7, (Vec3d)Vec3dHelper.copyCenteredHorizontally((Vec3i)blockPos));
            if (vec3d != null) {
                this.path = entityIn.func_70661_as().func_225466_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0);
                return this.path != null;
            }
        }
        return false;
    }

    private boolean reachedTarget(MobEntity entityIn, WalkTarget targetIn) {
        return targetIn.func_220966_a().func_220608_a().func_218139_n((Vec3i)entityIn.func_180425_c()) <= targetIn.func_220964_c();
    }
}

