/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.item;

import com.blackgear.cavesandcliffs.common.item.util.AbstractItem;
import com.blackgear.cavesandcliffs.common.util.math.CCBMathHelper;
import com.blackgear.cavesandcliffs.common.world.inventory.ClickAction;
import com.blackgear.cavesandcliffs.core.registries.CCBItems;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class BundleItem
extends AbstractItem {
    private static final int BAR_COLOR = CCBMathHelper.color(0.4f, 0.4f, 1.0f);

    public BundleItem(Item.Properties properties) {
        super(properties);
    }

    public static float getFullnessDisplay(ItemStack stack) {
        return (float)BundleItem.getContentWeight(stack) / 64.0f;
    }

    @Override
    public boolean overrideStackedOnOther(ItemStack bundle, ItemStack stack, ClickAction action, PlayerInventory inventory) {
        if (action == ClickAction.SECONDARY) {
            BundleItem.add(bundle, stack);
            return true;
        }
        return super.overrideStackedOnOther(bundle, stack, action, inventory);
    }

    @Override
    public boolean overrideStackedOnMe(ItemStack bundle, ItemStack stack, ClickAction action, PlayerInventory inventory) {
        if (action == ClickAction.SECONDARY) {
            if (stack.func_190926_b()) {
                BundleItem.removeAll(bundle, inventory);
            } else {
                BundleItem.add(bundle, stack);
            }
            return true;
        }
        return super.overrideStackedOnMe(bundle, stack, action, inventory);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        BundleItem.removeAll(stack, playerIn.field_71071_by);
        return ActionResult.func_226248_a_((Object)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int i = BundleItem.getContentWeight(stack);
        return i != 0 && i != 64;
    }

    public int func_77626_a(ItemStack stack) {
        return 13 * BundleItem.getContentWeight(stack) / 64 + 1;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return BAR_COLOR;
    }

    private static void add(ItemStack bundle, ItemStack stack) {
        if (!(Block.func_149634_a((Item)stack.func_77973_b()) instanceof ShulkerBoxBlock)) {
            CompoundNBT nbt = bundle.func_196082_o();
            if (!nbt.func_74764_b("Items")) {
                nbt.func_218657_a("Items", (INBT)new ListNBT());
            }
            int contentWeight = BundleItem.getContentWeight(bundle);
            int stackSize = BundleItem.getWeight(stack);
            int bundleFullness = Math.min(stack.func_190916_E(), (64 - contentWeight) / stackSize);
            if (bundleFullness != 0) {
                ListNBT listNBT = nbt.func_150295_c("Items", 10);
                Optional<INBT> optional = listNBT.stream().filter(value -> value instanceof CompoundNBT && ItemStack.func_77970_a((ItemStack)ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)value)), (ItemStack)stack)).findFirst();
                if (optional.isPresent()) {
                    CompoundNBT compoundNBT = (CompoundNBT)optional.get();
                    ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)compoundNBT);
                    itemStack.func_190917_f(bundleFullness);
                    itemStack.deserializeNBT(compoundNBT);
                } else {
                    ItemStack itemStack = stack.func_77946_l();
                    itemStack.func_190920_e(bundleFullness);
                    CompoundNBT compoundNBT = new CompoundNBT();
                    itemStack.deserializeNBT(compoundNBT);
                    listNBT.add((Object)compoundNBT);
                }
                stack.func_190918_g(bundleFullness);
            }
        }
    }

    private static int getWeight(ItemStack stack) {
        return stack.func_77973_b().equals(CCBItems.BUNDLE.get()) ? 4 + BundleItem.getContentWeight(stack) : 64 / stack.func_77976_d();
    }

    private static int getContentWeight(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_196082_o();
        if (!compoundNBT.func_74764_b("Items")) {
            return 0;
        }
        ListNBT listNBT = compoundNBT.func_150295_c("Items", 10);
        return listNBT.stream().map(value -> ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)value))).mapToInt(value -> BundleItem.getWeight(value) * value.func_190916_E()).sum();
    }

    private static void removeAll(ItemStack stack, PlayerInventory inventory) {
        CompoundNBT compoundNBT = stack.func_196082_o();
        if (compoundNBT.func_74764_b("Items")) {
            ListNBT listNBT = compoundNBT.func_150295_c("Items", 10);
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundNBT nbt = listNBT.func_150305_b(i);
                ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)nbt);
                if (!(inventory.field_70458_d instanceof ServerPlayerEntity) && !inventory.field_70458_d.func_184812_l_()) continue;
                inventory.func_191975_a(inventory.field_70458_d.field_70170_p, itemStack);
            }
            stack.func_196083_e("Items");
        }
    }
}

