/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.Task;

public class BrainHelper {
    private static final Map<Integer, Map<Activity, Set<Task<? super LivingEntity>>>> taskPriorityMap = Maps.newTreeMap();
    private static final Map<Activity, Set<MemoryModuleType<?>>> memoryMap = Maps.newHashMap();

    public static <U> void setMemory(Brain<?> brain, MemoryModuleType<U> memoryModuleType, @Nullable U object) {
        brain.func_218226_a(memoryModuleType, Optional.ofNullable(object));
    }

    public static void registerActivity(Brain<?> brain, Activity activity, int priorityStart, ImmutableList<? extends Task<?>> tasks) {
        BrainHelper.registerActivity(brain, activity, BrainHelper.getTaskPriorityList(priorityStart, tasks));
    }

    public static void registerActivity(Brain<?> brain, Activity activity, int priorityStart, ImmutableList<? extends Task<?>> tasks, MemoryModuleType<?> memoryType) {
        ImmutableSet setStatus = ImmutableSet.of((Object)Pair.of(memoryType, (Object)MemoryModuleStatus.VALUE_PRESENT));
        ImmutableSet setMemoryType = ImmutableSet.of(memoryType);
        BrainHelper.registerActivity(brain, activity, BrainHelper.getTaskPriorityList(priorityStart, tasks), setStatus, setMemoryType);
    }

    public static void registerActivity(Brain<?> brain, Activity activityIn, ImmutableList<? extends Pair<Integer, ? extends Task<?>>> tasks) {
        BrainHelper.registerActivity(brain, activityIn, tasks, ImmutableSet.of(), Sets.newHashSet());
    }

    public static void registerActivity(Brain<?> brain, Activity activity, ImmutableList<? extends Pair<Integer, ? extends Task<?>>> tasks, Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>> memoryStatuses) {
        BrainHelper.registerActivity(brain, activity, tasks, memoryStatuses, Sets.newHashSet());
    }

    private static void registerActivity(Brain<?> brain, Activity activity, ImmutableList<? extends Pair<Integer, ? extends Task>> tasks, Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>> memoryStatuses, Set<MemoryModuleType<?>> memoryTypes) {
        brain.field_218234_e.put(activity, memoryStatuses);
        if (!memoryTypes.isEmpty()) {
            memoryMap.put(activity, memoryTypes);
        }
        for (Pair pair : tasks) {
            brain.field_218232_c.computeIfAbsent(pair.getFirst(), activityPriority -> Maps.newHashMap()).computeIfAbsent(activity, activityIn -> Sets.newLinkedHashSet()).add(pair.getSecond());
        }
    }

    static ImmutableList<? extends Pair<Integer, ? extends Task<?>>> getTaskPriorityList(int priorityStart, ImmutableList<? extends Task<?>> tasks) {
        int i = priorityStart;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Task task : tasks) {
            builder.add((Object)Pair.of((Object)i++, (Object)task));
        }
        return builder.build();
    }

    public static void switchToFallbackActivity(Brain<?> brain) {
        BrainHelper.switchActivity(brain, brain.field_218237_h);
    }

    public static Optional<Activity> getActiveNonCoreActivity(Brain<?> brain) {
        for (Activity activity : brain.field_218236_g) {
            if (brain.field_218235_f.contains(activity)) continue;
            return Optional.of(activity);
        }
        return Optional.empty();
    }

    private static void switchActivity(Brain<?> brain, Activity activityIn) {
        if (!brain.func_218214_c(activityIn)) {
            BrainHelper.removeUnassociatedMemories(brain, activityIn);
            brain.field_218236_g.clear();
            brain.field_218236_g.addAll(brain.field_218235_f);
            brain.field_218236_g.add(activityIn);
        }
    }

    public static void removeUnassociatedMemories(Brain<?> brain, Activity activityIn) {
        for (Activity activity : brain.field_218236_g) {
            Set<MemoryModuleType<?>> set;
            if (activity == activityIn || (set = memoryMap.get(activity)) == null) continue;
            for (MemoryModuleType<?> memoryModuleType : set) {
                brain.func_218189_b(memoryModuleType);
            }
        }
    }

    public static void switchActivities(Brain<?> brain, List<Activity> activities) {
        for (Activity activity : activities) {
            if (!BrainHelper.hasRequiredMemories(brain, activity)) continue;
            BrainHelper.switchActivity(brain, activity);
            break;
        }
    }

    private static boolean hasRequiredMemories(Brain<?> brain, Activity activityIn) {
        if (!brain.field_218234_e.containsKey(activityIn)) {
            return false;
        }
        for (Pair memoryModules : (Set)brain.field_218234_e.get(activityIn)) {
            MemoryModuleStatus memoryModuleStatus;
            MemoryModuleType memoryModuleType = (MemoryModuleType)memoryModules.getFirst();
            if (brain.func_218196_a(memoryModuleType, memoryModuleStatus = (MemoryModuleStatus)memoryModules.getSecond())) continue;
            return false;
        }
        return true;
    }
}

