/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util.math;

import com.google.common.collect.AbstractIterator;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BlockPosHelper {
    public static BlockPos.Mutable setAndOffset(BlockPos.Mutable pos, Vec3i vec3i, Direction direction) {
        return pos.func_181079_c(vec3i.func_177958_n() + direction.func_82601_c(), vec3i.func_177956_o() + direction.func_96559_d(), vec3i.func_177952_p() + direction.func_82599_e());
    }

    public static BlockPos.Mutable setAndOffset(BlockPos.Mutable pos, Vec3i vec3i, int x, int y, int z) {
        return pos.func_181079_c(vec3i.func_177958_n() + x, vec3i.func_177956_o() + y, vec3i.func_177952_p() + z);
    }

    public static Iterable<BlockPos> withinManhattan(BlockPos pos, int xWidth, final int yHeight, final int zWidth) {
        final int radius = xWidth + yHeight + zWidth;
        final int getX = pos.func_177958_n();
        final int getY = pos.func_177956_o();
        final int getZ = pos.func_177952_p();
        return () -> new AbstractIterator<BlockPos>(){
            private final BlockPos.Mutable coordinateIterator = new BlockPos.Mutable();
            private int currentDepth;
            private int maxX;
            private int maxY;
            private int x;
            private int y;
            private boolean zMirror;

            protected BlockPos computeNext() {
                if (this.zMirror) {
                    this.zMirror = false;
                    this.coordinateIterator.func_223472_q(getZ - (this.coordinateIterator.func_177952_p() - getZ));
                    return this.coordinateIterator;
                }
                BlockPos.Mutable blockPos = null;
                while (blockPos == null) {
                    if (this.y > this.maxY) {
                        ++this.x;
                        if (this.x > this.maxX) {
                            ++this.currentDepth;
                            if (this.currentDepth > radius) {
                                return (BlockPos)this.endOfData();
                            }
                            this.maxX = Math.min(getX, this.currentDepth);
                            this.x = -this.maxX;
                        }
                        this.maxY = Math.min(yHeight, this.currentDepth - Math.abs(this.x));
                        this.y = -this.maxY;
                    }
                    int x = this.x;
                    int y = this.y;
                    int z = this.currentDepth - Math.abs(x) - Math.abs(y);
                    if (z <= zWidth) {
                        this.zMirror = z != 0;
                        blockPos = this.coordinateIterator.func_181079_c(getX + x, getY + y, getZ + z);
                    }
                    ++this.y;
                }
                return blockPos;
            }
        };
    }
}

