/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util.math;

import java.util.Random;
import net.minecraft.util.math.MathHelper;

public class IntRange {
    private final int minInclusive;
    private final int maxInclusive;

    public IntRange(int minInclusive, int maxInclusive) {
        if (maxInclusive < minInclusive) {
            throw new IllegalArgumentException("max must be >= minInclusive! Given minInclusive: " + minInclusive + ", Given max: " + maxInclusive);
        }
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    public static IntRange of(int minInclusive, int maxInclusive) {
        return new IntRange(minInclusive, maxInclusive);
    }

    public int randomValue(Random random) {
        return MathHelper.func_76136_a((Random)random, (int)this.minInclusive, (int)this.maxInclusive);
    }

    public int getMinInclusive() {
        return this.minInclusive;
    }

    public int getMaxInclusive() {
        return this.maxInclusive;
    }

    public String toString() {
        return "IntRange[" + this.minInclusive + "-" + this.maxInclusive + "]";
    }
}

