/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util.math;

import com.blackgear.cavesandcliffs.common.util.math.CCBMathHelper;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.util.IDynamicSerializable;

public class UniformFloat
implements IDynamicSerializable {
    private final float baseValue;
    private final float spread;

    private UniformFloat(float baseValue, float spread) {
        this.baseValue = baseValue;
        this.spread = spread;
    }

    public static UniformFloat fixed(float baseValue) {
        return new UniformFloat(baseValue, 0.0f);
    }

    public static UniformFloat of(float baseValue, float spread) {
        return new UniformFloat(baseValue, spread);
    }

    public float sample(Random rand) {
        return this.spread == 0.0f ? this.baseValue : CCBMathHelper.randomBetween(rand, this.baseValue, this.baseValue + this.spread);
    }

    public float getBaseValue() {
        return this.baseValue;
    }

    public float getMaxValue() {
        return this.baseValue + this.spread;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            UniformFloat uniformInt = (UniformFloat)object;
            return this.baseValue == uniformInt.baseValue && this.spread == uniformInt.spread;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.baseValue), Float.valueOf(this.spread));
    }

    public String toString() {
        return "[" + this.baseValue + '-' + (this.baseValue + this.spread) + ']';
    }

    public <T> T func_218175_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("base"), ops.createFloat(this.baseValue));
        builder.put(ops.createString("spread"), ops.createFloat(this.spread));
        return (T)new Dynamic(ops, ops.createMap((Map)builder.build())).getValue();
    }

    public static <T> UniformFloat deserialize(Dynamic<T> ops) {
        float baseValue = ops.get("base").asFloat(0.0f);
        float spread = ops.get("spread").asFloat(0.0f);
        return new UniformFloat(baseValue, spread);
    }
}

