/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util.math;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.util.IDynamicSerializable;

public class UniformInt
implements IDynamicSerializable {
    private final int baseValue;
    private final int spread;

    private UniformInt(int baseValue, int spread) {
        this.baseValue = baseValue;
        this.spread = spread;
    }

    public static UniformInt fixed(int baseValue) {
        return new UniformInt(baseValue, 0);
    }

    public static UniformInt of(int baseValue, int spread) {
        return new UniformInt(baseValue, spread);
    }

    public int sample(Random rand) {
        return this.spread == 0 ? this.baseValue : this.baseValue + rand.nextInt(this.spread + 1);
    }

    public int getBaseValue() {
        return this.baseValue;
    }

    public int getMaxValue() {
        return this.baseValue + this.spread;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            UniformInt uniformInt = (UniformInt)object;
            return this.baseValue == uniformInt.baseValue && this.spread == uniformInt.spread;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.spread);
    }

    public String toString() {
        return "[" + this.baseValue + '-' + (this.baseValue + this.spread) + ']';
    }

    public <T> T func_218175_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("base"), ops.createInt(this.baseValue));
        builder.put(ops.createString("spread"), ops.createInt(this.spread));
        return (T)new Dynamic(ops, ops.createMap((Map)builder.build())).getValue();
    }

    public static <T> UniformInt deserialize(Dynamic<T> ops) {
        int baseValue = ops.get("base").asInt(0);
        int spread = ops.get("spread").asInt(0);
        return new UniformInt(baseValue, spread);
    }
}

