/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.biome.provider;

import com.blackgear.cavesandcliffs.common.world.biome.layer.CaveBiomeLayer;
import com.blackgear.cavesandcliffs.core.CCBConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBiomes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;

public class CaveBiomeProvider {
    public static final List<Biome> caveBiomes = new ArrayList<Biome>();

    public static Layer stackCaveLayers(long seed) {
        LongFunction<IExtendedNoiseRandom> randomProvider = salt -> new LazyAreaLayerContext(1, seed, salt);
        IAreaFactory biomeFactory = new CaveBiomeLayer(caveBiomes).func_202823_a(randomProvider.apply(485868686L));
        for (int caveBiomeSize = 0; caveBiomeSize <= (Integer)CCBConfig.caveBiomeSize.get(); ++caveBiomeSize) {
            biomeFactory = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(28585L + (long)caveBiomeSize), biomeFactory);
        }
        biomeFactory = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(958687L), biomeFactory);
        return new Layer(biomeFactory);
    }

    public static void registerCaveBiome(Biome biome) {
        caveBiomes.add(biome);
    }

    public static void defaultCaveBiomes() {
        CaveBiomeProvider.registerCaveBiome((Biome)CCBBiomes.CAVES.get());
        CaveBiomeProvider.registerCaveBiome((Biome)CCBBiomes.DRIPSTONE_CAVES.get());
        CaveBiomeProvider.registerCaveBiome((Biome)CCBBiomes.LUSH_CAVES.get());
    }
}

