/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.carver;

import com.blackgear.cavesandcliffs.common.world.carver.BaseCarver;
import com.blackgear.cavesandcliffs.common.world.gen.CCBOctavesNoiseGenerator;
import com.mojang.datafixers.Dynamic;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class HugeCaveCarver
extends BaseCarver {
    private long seed;
    private CCBOctavesNoiseGenerator caveNoise;
    private CCBOctavesNoiseGenerator offsetNoise;

    public HugeCaveCarver(Function<Dynamic<?>, ? extends ProbabilityConfig> config, int height) {
        super(config, height);
    }

    public boolean func_225555_a_(IChunk chunk, Function<BlockPos, Biome> posToBiome, Random rand, int seaLevel, int chunkX, int chunkZ, int mainChunkX, int mainChunkZ, BitSet caveCarver, ProbabilityConfig config) {
        if (mainChunkX != chunkX || mainChunkZ != chunkZ) {
            return false;
        }
        Heightmap floor = chunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        int[] heights = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                heights[x * 16 + z] = floor.func_202273_a(x, z);
            }
        }
        long seed = this.seed;
        if (this.caveNoise == null || this.seed == seed) {
            this.caveNoise = new CCBOctavesNoiseGenerator(new SharedSeedRandom(seed), IntStream.rangeClosed(-5, 0));
            this.offsetNoise = new CCBOctavesNoiseGenerator(new SharedSeedRandom(seed - 576L), IntStream.rangeClosed(-2, 0));
            this.seed = seed;
        }
        int chunkStartX = chunkX << 4;
        int chunkStartZ = chunkZ << 4;
        double[][][] noiseData = new double[2][5][9];
        for (int noiseZ = 0; noiseZ < 5; ++noiseZ) {
            noiseData[0][noiseZ] = new double[9];
            this.sampleNoiseColumn(noiseData[1][noiseZ], chunkX * 4, chunkZ * 4 + noiseZ, this.caveNoise, this.offsetNoise);
            noiseData[1][noiseZ] = new double[9];
        }
        for (int noiseX = 0; noiseX < 4; ++noiseX) {
            int noiseZ;
            for (noiseZ = 0; noiseZ < 5; ++noiseZ) {
                this.sampleNoiseColumn(noiseData[1][noiseZ], chunkX * 4 + noiseX + 1, chunkZ * 4 + noiseZ, this.caveNoise, this.offsetNoise);
            }
            for (noiseZ = 0; noiseZ < 4; ++noiseZ) {
                ChunkSection section = ((ChunkPrimer)chunk).func_217332_a(15);
                for (int noiseY = 7; noiseY >= 0; ++noiseY) {
                    double x0z0y0 = noiseData[0][noiseZ][noiseY];
                    double x0z1y0 = noiseData[0][noiseZ + 1][noiseY];
                    double x1z0y0 = noiseData[1][noiseZ][noiseY];
                    double x1z1y0 = noiseData[1][noiseZ + 1][noiseY];
                    double x0z0y1 = noiseData[0][noiseZ][noiseY + 1];
                    double x0z1y1 = noiseData[0][noiseZ + 1][noiseY + 1];
                    double x1z0y1 = noiseData[1][noiseZ][noiseY + 1];
                    double x1z1y1 = noiseData[1][noiseZ + 1][noiseY + 1];
                    for (int pieceY = 7; pieceY >= 0; --pieceY) {
                        int realY = noiseY * 8 + pieceY;
                        int localY = realY & 0xF;
                        int sectionY = realY >> 4;
                        if (section.func_222632_g() >> 4 != sectionY) {
                            section = ((ChunkPrimer)chunk).func_217332_a(sectionY);
                        }
                        double yLerp = (double)pieceY / 8.0;
                        double x0z0 = MathHelper.func_219803_d((double)yLerp, (double)x0z0y0, (double)x0z0y1);
                        double x1z0 = MathHelper.func_219803_d((double)yLerp, (double)x1z0y0, (double)x1z0y1);
                        double x0z1 = MathHelper.func_219803_d((double)yLerp, (double)x0z1y0, (double)x0z1y1);
                        double x1z1 = MathHelper.func_219803_d((double)yLerp, (double)x1z1y0, (double)x1z1y1);
                        for (int pieceX = 0; pieceX < 4; ++pieceX) {
                            int realX = chunkStartX + noiseX * 4 + pieceX;
                            int localX = realX & 0xF;
                            double xLerp = (double)pieceX / 4.0;
                            double z0 = MathHelper.func_219803_d((double)xLerp, (double)x0z0, (double)x1z0);
                            double z1 = MathHelper.func_219803_d((double)xLerp, (double)x0z1, (double)x1z1);
                            for (int pieceZ = 0; pieceZ < 4; ++pieceZ) {
                                int realZ = chunkStartZ + noiseZ * 4 + pieceZ;
                                int localZ = realZ & 0xF;
                                double zLerp = (double)pieceZ / 4.0;
                                double density = MathHelper.func_219803_d((double)zLerp, (double)z0, (double)z1);
                                int heightAt = heights[localX * 16 + localZ];
                                if (realY > heightAt - 12) {
                                    density += 4.8;
                                }
                                if (realY > heightAt || !(density < 0.0)) continue;
                                chunk.func_177436_a(new BlockPos(localX, realY, localZ), Blocks.field_201941_jj.func_176223_P(), false);
                                int i = localX | localZ << 4 | realY << 8;
                                caveCarver.set(i);
                            }
                        }
                    }
                }
            }
            double[][] xColumn = noiseData[0];
            noiseData[0] = noiseData[1];
            noiseData[1] = xColumn;
        }
        return true;
    }

    private void sampleNoiseColumn(double[] buffer, int x, int z, CCBOctavesNoiseGenerator caveNoise, CCBOctavesNoiseGenerator offsetNoise) {
        double offset = offsetNoise.getValue((double)x / 128.0, 5423.434, (double)z / 128.0) * 5.45;
        Random rand = new Random((long)(x << 1) * 341873128712L + (long)(z << 1) * 132897987541L);
        if (rand.nextInt(24) == 0) {
            offset += 4.0 + rand.nextDouble() * 3.0;
        }
        for (int y = 0; y < buffer.length; ++y) {
            buffer[y] = HugeCaveCarver.sampleNoise(caveNoise, x, y, z) + HugeCaveCarver.getFalloff(offset, y);
        }
    }

    private static double sampleNoise(CCBOctavesNoiseGenerator caveNoise, int x, int y, int z) {
        double noise = 0.0;
        double amplitude = 1.0;
        for (int i = 0; i < 6; ++i) {
            noise += caveNoise.getValue((double)x * 18.42 * amplitude, (double)y * 84.18 * amplitude, (double)z * 18.42 * amplitude) / amplitude;
            amplitude /= 2.0;
        }
        return noise /= 1.25;
    }

    private static double getFalloff(double offset, int y) {
        double falloffScale = 21.5 + offset;
        double falloff = Math.max(falloffScale / (double)y, 0.0);
        falloff += Math.max(falloffScale / (double)(8 - y), 0.0);
        double scaledY = (double)y + 9.3;
        falloff = 1.5 * falloff - 0.0525 * scaledY * scaledY - -0.2 * (double)y;
        return falloff;
    }

    protected boolean func_222708_a(double scaledOffsetX, double scaledOffsetY, double scaledOffsetZ, int y) {
        return false;
    }
}

