/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.ImprovedNoiseGenerator;

public class CCBOctavesNoiseGenerator
implements INoiseGenerator {
    private final ImprovedNoiseGenerator[] noiseLevels;
    private final DoubleList amplitudes;
    private final double lowestFreqValueFactor;
    private final double lowestFreqInputFactor;

    public CCBOctavesNoiseGenerator(SharedSeedRandom random, IntStream octaves) {
        this(random, (List)octaves.boxed().collect(ImmutableList.toImmutableList()));
    }

    public CCBOctavesNoiseGenerator(SharedSeedRandom random, List<Integer> octaves) {
        this(random, (IntSortedSet)new IntRBTreeSet(octaves));
    }

    public static CCBOctavesNoiseGenerator create(SharedSeedRandom random, int octaves, DoubleList doubles) {
        return new CCBOctavesNoiseGenerator(random, (Pair<Integer, DoubleList>)Pair.of((Object)octaves, (Object)doubles));
    }

    private static Pair<Integer, DoubleList> makeAmplitudes(IntSortedSet octaves) {
        int j;
        if (octaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int i = -octaves.firstInt();
        int k = i + (j = octaves.lastInt()) + 1;
        if (k < 1) {
            throw new IllegalArgumentException("Total number of octaves need to be >= 1");
        }
        DoubleArrayList doubleList = new DoubleArrayList(new double[k]);
        IntBidirectionalIterator intBidirectionalIterator = octaves.iterator();
        while (intBidirectionalIterator.hasNext()) {
            int l = intBidirectionalIterator.nextInt();
            doubleList.set(l + i, 1.0);
        }
        return Pair.of((Object)(-i), (Object)doubleList);
    }

    private CCBOctavesNoiseGenerator(SharedSeedRandom random, IntSortedSet octaves) {
        this(random, CCBOctavesNoiseGenerator.makeAmplitudes(octaves));
    }

    public CCBOctavesNoiseGenerator(SharedSeedRandom random, Pair<Integer, DoubleList> octaves) {
        double d0;
        int i = (Integer)octaves.getFirst();
        this.amplitudes = (DoubleList)octaves.getSecond();
        ImprovedNoiseGenerator improvedNoiseGenerator = new ImprovedNoiseGenerator((Random)random);
        int j = this.amplitudes.size();
        int k = -i;
        this.noiseLevels = new ImprovedNoiseGenerator[j];
        if (k >= 0 && k < j && (d0 = this.amplitudes.getDouble(k)) != 0.0) {
            this.noiseLevels[k] = improvedNoiseGenerator;
        }
        for (int i1 = k - 1; i1 < 0; --i1) {
            if (i1 < j) {
                double d1 = this.amplitudes.getDouble(i1);
                if (d1 != 0.0) {
                    this.noiseLevels[i1] = new ImprovedNoiseGenerator((Random)random);
                    continue;
                }
                random.func_202423_a(262);
                continue;
            }
            random.func_202423_a(262);
        }
        if (k < j - 1) {
            long j1 = (long)(improvedNoiseGenerator.func_215456_a(0.0, 0.0, 0.0, 0.0, 0.0) * 9.223372036854776E18);
            SharedSeedRandom sharedSeedRandom = new SharedSeedRandom(j1);
            for (int l = k + 1; l < j; ++l) {
                if (l >= 0) {
                    double d2 = this.amplitudes.getDouble(l);
                    if (d2 != 0.0) {
                        this.noiseLevels[i] = new ImprovedNoiseGenerator((Random)sharedSeedRandom);
                        continue;
                    }
                    sharedSeedRandom.func_202423_a(262);
                    continue;
                }
                sharedSeedRandom.func_202423_a(262);
            }
        }
        this.lowestFreqInputFactor = Math.pow(2.0, -k);
        this.lowestFreqValueFactor = Math.pow(2.0, j - 1) / (Math.pow(2.0, j) - 1.0);
    }

    public double getValue(double x, double y, double z) {
        return this.getValue(x, y, z, 0.0, 0.0, false);
    }

    private double getValue(double x, double y, double z, double radiusX, double radiusZ, boolean flag) {
        double d0 = 0.0;
        double d1 = this.lowestFreqInputFactor;
        double d2 = this.lowestFreqValueFactor;
        for (int i = 0; i < this.noiseLevels.length; ++i) {
            ImprovedNoiseGenerator improvednoisegenerator = this.noiseLevels[i];
            if (improvednoisegenerator != null) {
                d0 += improvednoisegenerator.func_215456_a(CCBOctavesNoiseGenerator.maintainPrecision(x * d1), flag ? -improvednoisegenerator.field_76313_b : CCBOctavesNoiseGenerator.maintainPrecision(y * d1), CCBOctavesNoiseGenerator.maintainPrecision(z * d1), radiusX * d1, radiusZ * d1) * d2;
            }
            d1 *= 2.0;
            d2 /= 2.0;
        }
        return d0;
    }

    @Nullable
    public ImprovedNoiseGenerator getOctave(int octaveIndex) {
        return this.noiseLevels[this.noiseLevels.length - 1 - octaveIndex];
    }

    private static double maintainPrecision(double value) {
        return value - (double)MathHelper.func_76124_d((double)(value / 3.3554432E7 + 0.5)) * 3.3554432E7;
    }

    public double func_215460_a(double x, double y, double z, double value) {
        return this.getValue(x, y, 0.0, z, value, false);
    }
}

