/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;

public class GeodeBlockSettings {
    public final BlockStateProvider fillingProvider;
    public final BlockStateProvider innerLayerProvider;
    public final BlockStateProvider alternateInnerLayerProvider;
    public final BlockStateProvider middleLayerProvider;
    public final BlockStateProvider outerLayerProvider;
    public final List<BlockState> innerPlacements;

    public GeodeBlockSettings(BlockStateProvider fillingProvider, BlockStateProvider innerLayerProvider, BlockStateProvider alternateInnerLayerProvider, BlockStateProvider middleLayerProvider, BlockStateProvider outerLayerProvider, List<BlockState> innerPlacements) {
        this.fillingProvider = fillingProvider;
        this.innerLayerProvider = innerLayerProvider;
        this.alternateInnerLayerProvider = alternateInnerLayerProvider;
        this.middleLayerProvider = middleLayerProvider;
        this.outerLayerProvider = outerLayerProvider;
        this.innerPlacements = innerPlacements;
    }

    public <T> Dynamic<T> serialize(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("filling_provider"), this.fillingProvider.func_218175_a(ops));
        builder.put(ops.createString("inner_layer_provider"), this.innerLayerProvider.func_218175_a(ops));
        builder.put(ops.createString("alternate_inner_layer_provider"), this.alternateInnerLayerProvider.func_218175_a(ops));
        builder.put(ops.createString("middle_layer_provider"), this.middleLayerProvider.func_218175_a(ops));
        builder.put(ops.createString("outer_layer_provider"), this.outerLayerProvider.func_218175_a(ops));
        builder.put(ops.createString("inner_placements"), ops.createList(this.innerPlacements.stream().map(state -> BlockState.func_215689_a((DynamicOps)ops, (BlockState)state).getValue())));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> GeodeBlockSettings deserialize(Dynamic<T> ops) {
        BlockStateProviderType fillingProvider = (BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)ops.get("filling_provider").get("type").asString().orElseThrow(RuntimeException::new)));
        BlockStateProviderType innerLayerProvider = (BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)ops.get("inner_layer_provider").get("type").asString().orElseThrow(RuntimeException::new)));
        BlockStateProviderType alternateInnerLayerProvider = (BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)ops.get("alternate_inner_layer_provider").get("type").asString().orElseThrow(RuntimeException::new)));
        BlockStateProviderType middleLayerProvider = (BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)ops.get("middle_layer_provider").get("type").asString().orElseThrow(RuntimeException::new)));
        BlockStateProviderType outerLayerProvider = (BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)ops.get("outer_layer_provider").get("type").asString().orElseThrow(RuntimeException::new)));
        List innerPlacements = ops.get("inner_placements").asList(BlockState::func_215698_a);
        return new GeodeBlockSettings(fillingProvider.func_227399_a_(ops.get("filling_provider").orElseEmptyMap()), innerLayerProvider.func_227399_a_(ops.get("inner_layer_provider").orElseEmptyMap()), alternateInnerLayerProvider.func_227399_a_(ops.get("alternate_inner_layer_provider").orElseEmptyMap()), middleLayerProvider.func_227399_a_(ops.get("middle_layer_provider").orElseEmptyMap()), outerLayerProvider.func_227399_a_(ops.get("outer_layer_provider").orElseEmptyMap()), innerPlacements);
    }
}

