/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;

public class GeodeCrackSettings {
    public final double generateCrackChance;
    public final double baseCrackSize;
    public final int crackPointOffset;

    public GeodeCrackSettings(double generateCrackChance, double baseCrackSize, int crackPointOffset) {
        this.generateCrackChance = generateCrackChance;
        this.baseCrackSize = baseCrackSize;
        this.crackPointOffset = crackPointOffset;
    }

    public <T> Dynamic<T> serialize(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("generate_crack_chance"), ops.createDouble(this.generateCrackChance));
        builder.put(ops.createString("base_crack_size"), ops.createDouble(this.baseCrackSize));
        builder.put(ops.createString("crack_point_offset"), ops.createDouble((double)this.crackPointOffset));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> GeodeCrackSettings deserialize(Dynamic<T> ops) {
        double crackChance = ops.get("generate_crack_chance").asDouble(1.0);
        double crackSize = ops.get("base_crack_size").asDouble(2.0);
        int crackOffset = ops.get("crack_point_offset").asInt(2);
        return new GeodeCrackSettings(crackChance, crackSize, crackOffset);
    }
}

