/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;

public class GeodeLayerSettings {
    public final double filling;
    public final double innerLayer;
    public final double middleLayer;
    public final double outerLayer;

    public GeodeLayerSettings(double filling, double innerLayer, double middleLayer, double outerLayer) {
        this.filling = filling;
        this.innerLayer = innerLayer;
        this.middleLayer = middleLayer;
        this.outerLayer = outerLayer;
    }

    public <T> Dynamic<T> serialize(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("filling"), ops.createDouble(this.filling));
        builder.put(ops.createString("inner_layer"), ops.createDouble(this.innerLayer));
        builder.put(ops.createString("middle_layer"), ops.createDouble(this.middleLayer));
        builder.put(ops.createString("outer_layer"), ops.createDouble(this.outerLayer));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> GeodeLayerSettings deserialize(Dynamic<T> ops) {
        double filling = ops.get("filling").asDouble(1.7);
        double innerLayer = ops.get("inner_layer").asDouble(2.2);
        double middleLayer = ops.get("middle_layer").asDouble(3.2);
        double outerLayer = ops.get("outer_layer").asDouble(4.2);
        return new GeodeLayerSettings(filling, innerLayer, middleLayer, outerLayer);
    }
}

