/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import com.blackgear.cavesandcliffs.common.world.gen.CCBOctavesNoiseGenerator;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import net.minecraft.util.SharedSeedRandom;

public class NormalNoise {
    private final double valueFactor;
    private final CCBOctavesNoiseGenerator firstSampler;
    private final CCBOctavesNoiseGenerator secondSampler;

    public static NormalNoise create(SharedSeedRandom random, int octaves, double ... doubles) {
        return new NormalNoise(random, octaves, (DoubleList)new DoubleArrayList(doubles));
    }

    public static NormalNoise create(SharedSeedRandom random, int octaves, DoubleList doubleList) {
        return new NormalNoise(random, octaves, doubleList);
    }

    public NormalNoise(SharedSeedRandom random, int octaves, DoubleList doubleList) {
        this.firstSampler = CCBOctavesNoiseGenerator.create(random, octaves, doubleList);
        this.secondSampler = CCBOctavesNoiseGenerator.create(random, octaves, doubleList);
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        DoubleListIterator doubleListIterator = doubleList.iterator();
        while (doubleListIterator.hasNext()) {
            int i = doubleListIterator.nextIndex();
            double d0 = doubleListIterator.nextDouble();
            if (d0 == 0.0) continue;
            min = Math.min(min, i);
            max = Math.max(max, i);
        }
        this.valueFactor = 0.16666666666666666 / this.createAmplitude(max - min);
    }

    private double createAmplitude(int octaves) {
        return 0.1 * (1.0 + 1.0 / (double)(octaves + 1));
    }

    public double getValue(double xIn, double yIn, double zIn) {
        double x = xIn * 1.0181268882175227;
        double y = yIn * 1.0181268882175227;
        double z = zIn * 1.0181268882175227;
        return (this.firstSampler.getValue(xIn, yIn, zIn) + this.secondSampler.getValue(x, y, z)) * this.valueFactor;
    }
}

